/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.focus;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.focus.FocusManagerState;
import com.simsilica.lemur.focus.FocusNavigationFunctions;
import com.simsilica.lemur.focus.FocusTraversal;
import com.simsilica.lemur.input.FunctionId;
import com.simsilica.lemur.input.InputMapper;
import com.simsilica.lemur.input.InputState;
import com.simsilica.lemur.input.StateFunctionListener;

public class FocusNavigationState
extends BaseAppState {
    private FocusManagerState focusState;
    private InputMapper inputMapper;
    private InputHandler inputHandler = new InputHandler();

    public FocusNavigationState(InputMapper inputMapper, FocusManagerState focusState) {
        this.inputMapper = inputMapper;
        this.focusState = focusState;
    }

    public Spatial getDefaultFocus(Spatial spatial) {
        FocusTraversal ft = FocusNavigationState.getFocusTraversal(spatial);
        return ft != null ? ft.getDefaultFocus() : spatial;
    }

    public Spatial requestChangeFocus(Spatial spatial, FocusTraversal.TraversalDirection dir) {
        if (spatial == null) {
            throw new IllegalArgumentException("Cannot traverse focus from a null spatial");
        }
        Spatial container = this.getFocusContainer(spatial);
        if (container == null) {
            return null;
        }
        FocusTraversal ft = FocusNavigationState.getFocusTraversal(container);
        Spatial next = ft.getRelativeFocus(spatial, dir);
        if (next != null) {
            this.focusState.setFocus(next);
            return next;
        }
        return this.requestChangeFocus(container, dir);
    }

    protected void initialize(Application app) {
        FocusNavigationFunctions.initializeDefaultMappings(this.inputMapper);
        this.inputMapper.addStateListener(this.inputHandler, FocusNavigationFunctions.F_NEXT, FocusNavigationFunctions.F_PREV, FocusNavigationFunctions.F_X_AXIS, FocusNavigationFunctions.F_Y_AXIS, FocusNavigationFunctions.F_ACTIVATE);
    }

    protected void cleanup(Application app) {
        this.inputMapper.removeStateListener(this.inputHandler, FocusNavigationFunctions.F_NEXT, FocusNavigationFunctions.F_PREV, FocusNavigationFunctions.F_X_AXIS, FocusNavigationFunctions.F_Y_AXIS, FocusNavigationFunctions.F_ACTIVATE);
    }

    protected void onEnable() {
        this.inputMapper.activateGroup("UI Navigation");
    }

    protected void onDisable() {
        this.inputMapper.deactivateGroup("UI Navigation");
    }

    protected Spatial getCurrentFocus() {
        return ((FocusManagerState)this.getState(FocusManagerState.class)).getFocus();
    }

    protected static <T> T getControl(Spatial s, Class<T> type) {
        if (s == null) {
            return null;
        }
        for (int i = 0; i < s.getNumControls(); ++i) {
            Control c = s.getControl(i);
            if (!type.isInstance(c)) continue;
            return type.cast(c);
        }
        return null;
    }

    public static FocusTraversal getFocusTraversal(Spatial s) {
        if (s == null) {
            return null;
        }
        FocusTraversal ft = FocusNavigationState.getControl(s, FocusTraversal.class);
        if (ft instanceof GuiControl && ((GuiControl)ft).getLayout() == null) {
            return null;
        }
        return ft;
    }

    protected Spatial getFocusContainer(Spatial spatial) {
        if (spatial == null) {
            return null;
        }
        for (Node s = spatial.getParent(); s != null; s = s.getParent()) {
            FocusTraversal ft = FocusNavigationState.getFocusTraversal((Spatial)s);
            if (ft == null) continue;
            return s;
        }
        return null;
    }

    protected void navigate(FocusTraversal.TraversalDirection dir) {
        Spatial current = this.getCurrentFocus();
        if (current == null) {
            return;
        }
        this.requestChangeFocus(current, dir);
    }

    protected void navigateLeft() {
        Spatial current = this.getCurrentFocus();
        if (current == null) {
            return;
        }
        this.requestChangeFocus(current, FocusTraversal.TraversalDirection.Left);
    }

    protected void navigateRight() {
        Spatial current = this.getCurrentFocus();
        if (current == null) {
            return;
        }
        this.requestChangeFocus(current, FocusTraversal.TraversalDirection.Right);
    }

    protected void navigateUp() {
        Spatial current = this.getCurrentFocus();
        if (current == null) {
            return;
        }
        this.requestChangeFocus(current, FocusTraversal.TraversalDirection.Up);
    }

    protected void navigateDown() {
        Spatial current = this.getCurrentFocus();
        if (current == null) {
            return;
        }
        this.requestChangeFocus(current, FocusTraversal.TraversalDirection.Down);
    }

    private class InputHandler
    implements StateFunctionListener {
        private InputHandler() {
        }

        @Override
        public void valueChanged(FunctionId func, InputState value, double tpf) {
            if (value == InputState.Off) {
                return;
            }
            if (func == FocusNavigationFunctions.F_NEXT) {
                FocusNavigationState.this.navigate(FocusTraversal.TraversalDirection.Next);
            }
            if (func == FocusNavigationFunctions.F_PREV) {
                FocusNavigationState.this.navigate(FocusTraversal.TraversalDirection.Previous);
            }
            if (func == FocusNavigationFunctions.F_X_AXIS) {
                if (value == InputState.Positive) {
                    FocusNavigationState.this.navigateRight();
                } else {
                    FocusNavigationState.this.navigateLeft();
                }
            }
            if (func == FocusNavigationFunctions.F_Y_AXIS) {
                if (value == InputState.Positive) {
                    FocusNavigationState.this.navigateUp();
                } else {
                    FocusNavigationState.this.navigateDown();
                }
            }
        }
    }
}

