/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.focus;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.simsilica.lemur.focus.FocusNavigationState;
import com.simsilica.lemur.focus.FocusTarget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FocusManagerState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(FocusManagerState.class);
    private Spatial focus;
    private FocusNavigationState focusNavigationState;
    private List<Spatial> focusHierarchy = Collections.emptyList();
    private boolean hierarchyUpdating = false;
    private Spatial nextFocus = null;

    public FocusManagerState() {
        this.setEnabled(true);
    }

    public static FocusTarget findFocusTarget(Spatial s) {
        if (s == null) {
            return null;
        }
        for (int i = 0; i < s.getNumControls(); ++i) {
            Control c = s.getControl(i);
            if (!(c instanceof FocusTarget)) continue;
            return (FocusTarget)c;
        }
        return null;
    }

    public void setFocusNavigationState(FocusNavigationState focusNavigationState) {
        this.focusNavigationState = focusNavigationState;
    }

    public FocusNavigationState getFocusNavigationState() {
        return this.focusNavigationState;
    }

    public void setFocus(Spatial focus) {
        block13: {
            if (log.isTraceEnabled()) {
                log.trace("setFocus(" + focus + ")");
            }
            if (this.hierarchyUpdating) {
                log.trace("hierarchy is updating, saving it for later");
                this.nextFocus = focus;
                return;
            }
            if (this.getFocusNavigationState() != null) {
                focus = this.getFocusNavigationState().getDefaultFocus(focus);
                if (log.isTraceEnabled()) {
                    log.trace("resolved to:" + focus);
                }
            }
            if (this.focus == focus) {
                return;
            }
            this.focus = focus;
            if (this.isEnabled()) {
                this.hierarchyUpdating = true;
                try {
                    this.updateFocusHierarchy();
                    if (this.nextFocus == null || this.nextFocus == focus) break block13;
                    HashSet<Spatial> visited = new HashSet<Spatial>();
                    visited.add(focus);
                    while (this.nextFocus != null) {
                        if (!visited.add(this.nextFocus)) {
                            throw new IllegalStateException("Loop detected in side-effect focus processing");
                        }
                        if (this.nextFocus == this.focus) {
                            break;
                        }
                        this.focus = this.nextFocus;
                        this.nextFocus = null;
                        if (log.isTraceEnabled()) {
                            log.trace("processing pending focus:" + this.focus);
                        }
                        this.updateFocusHierarchy();
                    }
                }
                finally {
                    this.hierarchyUpdating = false;
                }
            }
        }
    }

    public boolean releaseFocus(Spatial focus) {
        if (log.isTraceEnabled()) {
            log.trace("releaseFocus(" + focus + ")");
        }
        if (this.focusHierarchy.indexOf(focus) < 0) {
            log.trace(" not in focus chain");
            return false;
        }
        this.setFocus(null);
        return true;
    }

    public Spatial getFocus() {
        return this.focus;
    }

    protected void initialize(Application app) {
    }

    protected void cleanup(Application app) {
    }

    public void update(float tpf) {
        if (!this.isConnected(this.focusHierarchy)) {
            log.trace("current focus hierarchy has is disconnected");
            this.setFocus(null);
        }
    }

    protected List<Spatial> getHierarchy(Spatial s) {
        if (s == null) {
            return Collections.emptyList();
        }
        ArrayList<Spatial> result = new ArrayList<Spatial>();
        while (s != null) {
            result.add(0, s);
            s = s.getParent();
        }
        return result;
    }

    protected boolean isConnected(List<Spatial> hierarchy) {
        if (hierarchy.size() < 2) {
            return true;
        }
        Spatial last = hierarchy.get(0);
        for (int i = 1; i < hierarchy.size(); ++i) {
            Spatial child = hierarchy.get(i);
            if (child.getParent() != last) {
                return false;
            }
            last = child;
        }
        return true;
    }

    protected void updateFocusHierarchy() {
        FocusTarget target;
        int i;
        if (log.isTraceEnabled()) {
            log.trace("updateFocusHiearchy():" + this.focus);
        }
        List<Spatial> oldHierarchy = this.focusHierarchy;
        List<Spatial> newHierarchy = this.getHierarchy(this.focus);
        int lca = -1;
        int commonLength = Math.min(oldHierarchy.size(), newHierarchy.size());
        for (int i2 = 0; i2 < commonLength; ++i2) {
            Spatial s2;
            Spatial s1 = oldHierarchy.get(i2);
            if (s1 == (s2 = newHierarchy.get(i2))) continue;
            lca = i2 - 1;
            break;
        }
        Spatial originalFocus = this.focus;
        log.trace("updating focus lost");
        for (i = lca + 1; i < oldHierarchy.size(); ++i) {
            target = FocusManagerState.findFocusTarget(oldHierarchy.get(i));
            if (log.isTraceEnabled()) {
                log.trace("[" + i + "]:" + oldHierarchy.get(i) + "  target:" + target);
            }
            if (target == null) continue;
            target.focusLost();
        }
        log.trace("updating focus gained");
        for (i = lca + 1; i < newHierarchy.size(); ++i) {
            target = FocusManagerState.findFocusTarget(newHierarchy.get(i));
            if (log.isTraceEnabled()) {
                log.trace("[" + i + "]:" + newHierarchy.get(i) + "  target:" + target);
            }
            if (target == null) continue;
            target.focusGained();
        }
        this.focusHierarchy = newHierarchy;
    }

    protected void onEnable() {
        for (Spatial s : this.focusHierarchy) {
            FocusTarget target = FocusManagerState.findFocusTarget(s);
            if (target == null) continue;
            target.focusGained();
        }
    }

    protected void onDisable() {
        for (Spatial s : this.focusHierarchy) {
            FocusTarget target = FocusManagerState.findFocusTarget(s);
            if (target == null) continue;
            target.focusLost();
        }
    }
}

