/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.event;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.renderer.RenderManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAppState
implements AppState {
    static Logger log = LoggerFactory.getLogger(BaseAppState.class);
    private Application app;
    private boolean initialized;
    private boolean enabled = true;
    private String id;

    protected abstract void initialize(Application var1);

    protected abstract void cleanup(Application var1);

    protected abstract void enable();

    protected abstract void disable();

    public final void initialize(AppStateManager stateManager, Application app) {
        if (log.isTraceEnabled()) {
            log.trace("initialize():" + this);
        }
        this.app = app;
        this.initialized = true;
        this.initialize(app);
        if (this.isEnabled()) {
            this.enable();
        }
    }

    protected void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    public final Application getApplication() {
        return this.app;
    }

    public final AppStateManager getStateManager() {
        return this.app.getStateManager();
    }

    public final <T extends AppState> T getState(Class<T> type) {
        return (T)this.getStateManager().getState(type);
    }

    public final void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        if (!this.isInitialized()) {
            return;
        }
        if (enabled) {
            log.trace("enable():" + this);
            this.enable();
        } else {
            log.trace("disable():" + this);
            this.disable();
        }
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public void stateAttached(AppStateManager stateManager) {
    }

    public void stateDetached(AppStateManager stateManager) {
    }

    public void update(float tpf) {
    }

    public void render(RenderManager rm) {
    }

    public void postRender() {
    }

    public final void cleanup() {
        if (log.isTraceEnabled()) {
            log.trace("cleanup():" + this);
        }
        if (this.isEnabled()) {
            this.disable();
        }
        this.cleanup(this.app);
        this.initialized = false;
    }
}

