/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.effect;

import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import com.simsilica.lemur.anim.Animation;
import com.simsilica.lemur.anim.AnimationState;
import com.simsilica.lemur.anim.TweenAnimation;
import com.simsilica.lemur.effect.Effect;
import com.simsilica.lemur.effect.EffectInfo;
import java.util.HashMap;
import java.util.Map;

public class EffectControl<T extends Spatial>
extends AbstractControl {
    private AnimationState state;
    private final Map<String, Effect<? super T>> effects = new HashMap<String, Effect<? super T>>();
    private final Map<String, EffectInfo> channels = new HashMap<String, EffectInfo>();

    public EffectControl(AnimationState anim) {
        this.state = anim;
    }

    public EffectControl() {
        this(null);
    }

    public T getSpatial() {
        return (T)super.getSpatial();
    }

    protected AnimationState anim() {
        if (this.state == null) {
            this.state = AnimationState.getDefaultInstance();
        }
        return this.state;
    }

    public void addEffect(String name, Effect<? super T> effect) {
        this.effects.put(name, effect);
    }

    public boolean hasEffect(String name) {
        return this.effects.containsKey(name);
    }

    public Effect<? super T> removeEffect(String name) {
        return this.effects.remove(name);
    }

    public Map<String, Effect<? super T>> getEffects() {
        return this.effects;
    }

    public EffectInfo runEffect(String name) {
        return this.runEffect(name, true);
    }

    public EffectInfo runEffect(String name, boolean fastForward) {
        if (this.spatial == null) {
            return null;
        }
        Effect<T> e = this.effects.get(name);
        if (e == null) {
            return null;
        }
        String channel = e.getChannel();
        EffectInfo existing = null;
        if (channel != null) {
            existing = this.channels.remove(channel);
        }
        Animation a = e.create(this.getSpatial(), existing);
        if (fastForward && existing != null && e != existing.getEffect() && a instanceof TweenAnimation && existing.getAnimation() instanceof TweenAnimation) {
            TweenAnimation aFrom = (TweenAnimation)existing.getAnimation();
            TweenAnimation aTo = (TweenAnimation)a;
            aTo.fastForwardPercent(aFrom.getPercentRemaining());
        }
        if (existing != null) {
            this.anim().cancel(existing.getAnimation());
        }
        EffectInfo result = null;
        if (a != null) {
            this.anim().add(a);
            result = new EffectInfo(name, e, a);
            if (channel != null) {
                this.channels.put(channel, result);
            }
        }
        return result;
    }

    protected void controlUpdate(float tpf) {
    }

    protected void controlRender(RenderManager rm, ViewPort vp) {
    }
}

