/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.demo;

import com.jme3.app.Application;
import com.jme3.app.FlyCamAppState;
import com.jme3.app.SimpleApplication;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import com.simsilica.lemur.Checkbox;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.DefaultRangedValueModel;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.RangedValueModel;
import com.simsilica.lemur.Slider;
import com.simsilica.lemur.TextField;
import com.simsilica.lemur.component.DynamicInsetsComponent;
import com.simsilica.lemur.component.QuadBackgroundComponent;
import com.simsilica.lemur.component.TbtQuadBackgroundComponent;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.event.CursorEventControl;
import com.simsilica.lemur.event.CursorMotionEvent;
import com.simsilica.lemur.event.DefaultCursorListener;
import com.simsilica.lemur.event.DragHandler;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.style.Styles;

public class BasicDemo
extends SimpleApplication {
    private VersionedReference<Double> redRef;
    private VersionedReference<Double> greenRef;
    private VersionedReference<Double> blueRef;
    private VersionedReference<Double> alphaRef;
    private VersionedReference<Boolean> showStatsRef;
    private VersionedReference<Boolean> showFpsRef;
    private ColorRGBA boxColor = ColorRGBA.Blue.clone();
    private Panel test;
    private TextField tf;
    private String strInsertText = "Inserted ";

    public static void main(String[] args) {
        BasicDemo app = new BasicDemo();
        app.start();
    }

    public void simpleInitApp() {
        GuiGlobals.initialize((Application)this);
        this.stateManager.detach(this.stateManager.getState(FlyCamAppState.class));
        Styles styles = GuiGlobals.getInstance().getStyles();
        styles.getSelector("thumb.button", "glass").set("text", "[]", false);
        styles.getSelector("panel", "glass").set("background", new QuadBackgroundComponent(new ColorRGBA(0.0f, 0.25f, 0.25f, 0.5f)));
        styles.getSelector("checkbox", "glass").set("background", new QuadBackgroundComponent(new ColorRGBA(0.0f, 0.5f, 0.5f, 0.5f)));
        styles.getSelector("spacer", "glass").set("background", new QuadBackgroundComponent(new ColorRGBA(1.0f, 0.0f, 0.0f, 0.0f)));
        styles.getSelector("header", "glass").set("background", new QuadBackgroundComponent(new ColorRGBA(0.0f, 0.75f, 0.75f, 0.5f)));
        styles.getSelector("header", "glass").set("shadowColor", new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f));
        Container hudPanel = new Container("glass");
        hudPanel.setLocalTranslation(5.0f, this.cam.getHeight() - 50, 0.0f);
        this.guiNode.attachChild((Spatial)hudPanel);
        Container panel = new Container("glass");
        hudPanel.addChild(panel, new Object[0]);
        panel.setBackground(new QuadBackgroundComponent(new ColorRGBA(0.0f, 0.5f, 0.5f, 0.5f), 5.0f, 5.0f, 0.02f, false));
        panel.addChild(new Label("Stats Settings", new ElementId("header"), "glass"), new Object[0]);
        panel.addChild(new Panel(2.0f, 2.0f, ColorRGBA.Cyan, "glass"), new Object[0]).setUserData("layer", 2);
        Checkbox temp = panel.addChild(new Checkbox("Show Stats"), new Object[0]);
        temp.setChecked(true);
        this.showStatsRef = temp.getModel().createReference();
        temp = panel.addChild(new Checkbox("Show FPS"), new Object[0]);
        temp.setChecked(true);
        this.showFpsRef = temp.getModel().createReference();
        hudPanel.addChild(new Panel(10.0f, 10.0f, new ElementId("spacer"), "glass"), new Object[0]);
        panel = new Container("glass");
        panel.setBackground(new QuadBackgroundComponent(new ColorRGBA(0.0f, 0.5f, 0.5f, 0.5f), 5.0f, 5.0f, 0.02f, false));
        panel.addChild(new Label("Cube Settings", new ElementId("header"), "glass"), new Object[0]);
        panel.addChild(new Panel(2.0f, 2.0f, ColorRGBA.Cyan, "glass"), new Object[0]).setUserData("layer", 2);
        panel.addChild(new Label("Red:"), new Object[0]);
        final Slider redSlider = new Slider("glass");
        redSlider.setBackground(new QuadBackgroundComponent(new ColorRGBA(0.5f, 0.1f, 0.1f, 0.5f), 5.0f, 5.0f, 0.02f, false));
        this.redRef = panel.addChild(redSlider, new Object[0]).getModel().createReference();
        CursorEventControl.addListenersToSpatial((Spatial)redSlider, new DefaultCursorListener(){

            @Override
            public void cursorMoved(CursorMotionEvent event, Spatial target, Spatial capture) {
                System.out.println("event:" + event);
                Vector3f cp = event.getCollision().getContactPoint();
                cp = redSlider.worldToLocal(cp, null);
                System.out.println("Range value:" + redSlider.getValueForLocation(cp));
            }
        });
        panel.addChild(new Label("Green:"), new Object[0]);
        this.greenRef = panel.addChild(new Slider("glass"), new Object[0]).getModel().createReference();
        panel.addChild(new Label("Blue:"), new Object[0]);
        this.blueRef = panel.addChild(new Slider((RangedValueModel)new DefaultRangedValueModel(0.0, 100.0, 100.0), "glass"), new Object[0]).getModel().createReference();
        panel.addChild(new Label("Alpha:"), new Object[0]);
        this.alphaRef = panel.addChild(new Slider((RangedValueModel)new DefaultRangedValueModel(0.0, 100.0, 100.0), "glass"), new Object[0]).getModel().createReference();
        hudPanel.addChild(panel, new Object[0]);
        hudPanel.addChild(new Panel(10.0f, 10.0f, new ElementId("spacer"), "glass"), new Object[0]);
        panel = new Container("glass");
        panel.addChild(new Label("Test entry:", "glass"), new Object[0]);
        hudPanel.addChild(panel, new Object[0]);
        this.guiNode.attachChild((Spatial)hudPanel);
        Vector3f hudSize = new Vector3f(200.0f, 0.0f, 0.0f);
        hudSize.maxLocal(hudPanel.getPreferredSize());
        hudPanel.setPreferredSize(hudSize);
        Box box = new Box(1.0f, 1.0f, 1.0f);
        Geometry geom = new Geometry("Box", (Mesh)box);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setColor("Color", this.boxColor);
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        geom.setMaterial(mat);
        this.rootNode.attachChild((Spatial)geom);
        Container testPanel = new Container();
        testPanel.setPreferredSize(new Vector3f(200.0f, 200.0f, 0.0f));
        testPanel.setBackground(TbtQuadBackgroundComponent.create("/com/simsilica/lemur/icons/border.png", 1.0f, 2, 2, 3, 3, 0.0f, false));
        Label test = testPanel.addChild(new Label("Border Test"), new Object[0]);
        test.setShadowColor(ColorRGBA.Red);
        test.setInsetsComponent(new DynamicInsetsComponent(0.5f, 0.5f, 0.5f, 0.5f));
        testPanel.setLocalTranslation(400.0f, 400.0f, 0.0f);
        CursorEventControl.addListenersToSpatial((Spatial)testPanel, new DragHandler());
        this.guiNode.attachChild((Spatial)testPanel);
    }

    public void simpleUpdate(float tpf) {
        if (this.showStatsRef.update()) {
            this.setDisplayStatView(this.showStatsRef.get());
        }
        if (this.showFpsRef.update()) {
            this.setDisplayFps(this.showFpsRef.get());
        }
        boolean updateColor = false;
        if (this.redRef.update()) {
            updateColor = true;
        }
        if (this.greenRef.update()) {
            updateColor = true;
        }
        if (this.blueRef.update()) {
            updateColor = true;
        }
        if (this.alphaRef.update()) {
            updateColor = true;
        }
        if (updateColor) {
            this.boxColor.set((float)(this.redRef.get() / 100.0), (float)(this.greenRef.get() / 100.0), (float)(this.blueRef.get() / 100.0), (float)(this.alphaRef.get() / 100.0));
        }
    }
}

