/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.core;

import com.google.common.collect.Iterators;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.focus.FocusManagerState;
import com.simsilica.lemur.focus.FocusNavigationState;
import com.simsilica.lemur.focus.FocusTarget;
import com.simsilica.lemur.focus.FocusTraversal;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FocusTraversalAdapter
implements FocusTraversal {
    private GuiLayout layout;
    private boolean focusRoot;

    public FocusTraversalAdapter(GuiLayout layout) {
        this.layout = layout;
    }

    public void setLayout(GuiLayout layout) {
        this.layout = layout;
    }

    public GuiLayout getLayout() {
        return this.layout;
    }

    @Override
    public Spatial getDefaultFocus() {
        for (Spatial spatial : this.layout.getChildren()) {
            Spatial defaultFocus;
            FocusTarget target = FocusManagerState.findFocusTarget(spatial);
            if (target != null && target.isFocusable()) {
                return spatial;
            }
            FocusTraversal ft = FocusNavigationState.getFocusTraversal(spatial);
            if (ft == null || (defaultFocus = ft.getDefaultFocus()) == null) continue;
            return defaultFocus;
        }
        return null;
    }

    @Override
    public Spatial getRelativeFocus(Spatial from, FocusTraversal.TraversalDirection direction) {
        switch (direction) {
            case Up: 
            case Left: 
            case Previous: {
                return this.getPrevious(from);
            }
            default: {
                return this.getNext(from);
            }
            case Home: 
            case PageHome: {
                return this.getFirst();
            }
            case End: 
            case PageEnd: 
        }
        return this.getLast();
    }

    public void setFocusRoot(boolean b) {
        this.focusRoot = b;
    }

    @Override
    public boolean isFocusRoot() {
        return this.focusRoot;
    }

    protected Spatial getFirst() {
        Spatial first = (Spatial)Iterators.get((Iterator)new ChildIterator(FocusTraversal.TraversalDirection.PageHome), (int)0, null);
        return first;
    }

    protected Spatial getLast() {
        return (Spatial)Iterators.getLast((Iterator)new ChildIterator(FocusTraversal.TraversalDirection.PageEnd), null);
    }

    protected Spatial getNext(Spatial from) {
        Spatial next = (Spatial)Iterators.get((Iterator)new ChildIterator(from, null, FocusTraversal.TraversalDirection.PageHome), (int)0, null);
        if (next == null && this.focusRoot) {
            next = this.getFirst();
        }
        return next;
    }

    protected Spatial getPrevious(Spatial from) {
        Spatial previous = (Spatial)Iterators.getLast((Iterator)new ChildIterator(null, from, FocusTraversal.TraversalDirection.PageEnd), null);
        if (previous == null && this.focusRoot) {
            previous = this.getLast();
        }
        return previous;
    }

    private class ChildIterator
    implements Iterator<Spatial> {
        private Iterator<Node> delegate;
        private Spatial start;
        private Spatial end;
        private FocusTraversal.TraversalDirection entryDir;
        private boolean started;
        private Spatial next;

        public ChildIterator(FocusTraversal.TraversalDirection entryDir) {
            this(null, null, entryDir);
        }

        public ChildIterator(Spatial start, Spatial end, FocusTraversal.TraversalDirection entryDir) {
            this.delegate = FocusTraversalAdapter.this.layout.getChildren().iterator();
            this.start = start;
            this.end = end;
            this.entryDir = entryDir;
            this.started = start == null;
            this.fetch();
        }

        protected void fetch() {
            this.next = null;
            while (this.delegate.hasNext()) {
                Spatial newFocus;
                Spatial child = (Spatial)this.delegate.next();
                if (this.start != null && child == this.start) {
                    this.started = true;
                    continue;
                }
                if (this.end != null && child == this.end) break;
                if (!this.started) continue;
                FocusTarget target = FocusManagerState.findFocusTarget(child);
                if (target != null && target.isFocusable()) {
                    this.next = child;
                    break;
                }
                FocusTraversal ft = FocusNavigationState.getFocusTraversal(child);
                if (ft == null || (newFocus = ft.getRelativeFocus(null, this.entryDir)) == null) continue;
                this.next = newFocus;
                break;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Spatial next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Spatial result = this.next;
            this.fetch();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

