/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.core;

import com.jme3.util.SafeArrayList;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.GuiControl;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentStack
extends AbstractList<GuiComponent> {
    static Logger log = LoggerFactory.getLogger(ComponentStack.class);
    private GuiControl parent;
    private SafeArrayList<GuiComponent> components = new SafeArrayList(GuiComponent.class);
    private List<GuiComponent> topList = new ArrayList<GuiComponent>();
    private Map<String, GuiComponent> index = new HashMap<String, GuiComponent>();
    private String[] layerOrder;

    public ComponentStack(String ... layerOrder) {
        this.layerOrder = layerOrder;
    }

    protected GuiComponent[] getArray() {
        return (GuiComponent[])this.components.getArray();
    }

    @Override
    public GuiComponent get(int index) {
        return (GuiComponent)this.components.get(index);
    }

    @Override
    public int size() {
        return this.components.size();
    }

    public void setLayerOrder(String ... layerOrder) {
        this.layerOrder = layerOrder;
        this.rebuildStack();
        if (this.parent != null) {
            this.parent.invalidate();
        }
    }

    public boolean hasLayer(String layerName) {
        for (String s : this.layerOrder) {
            if (!Objects.equals(s, layerName)) continue;
            return true;
        }
        return false;
    }

    public String[] getLayerOrder() {
        return this.layerOrder;
    }

    public void attach(GuiControl parent) {
        this.parent = parent;
        for (GuiComponent c : this.components) {
            c.attach(parent);
        }
    }

    public void detach(GuiControl parent) {
        for (GuiComponent c : this.components) {
            c.detach(parent);
        }
    }

    protected void rebuildStack() {
        this.components.clear();
        for (String s : this.layerOrder) {
            GuiComponent layer = this.index.get(s);
            if (layer == null) continue;
            this.components.add((Object)layer);
        }
        this.components.addAll(this.topList);
    }

    public <T extends GuiComponent> T addComponent(T c) {
        this.topList.add(c);
        this.components.add(c);
        if (this.parent != null) {
            c.attach(this.parent);
            this.parent.invalidate();
        }
        return c;
    }

    public <T extends GuiComponent> T setComponent(String layer, T c) {
        if (!this.hasLayer(layer)) {
            throw new IllegalArgumentException("Layer name does not exist in layer ordering:" + layer + ", layers=" + Arrays.asList(this.layerOrder));
        }
        if (c != null) {
            GuiComponent original;
            if (c.getGuiControl() != null) {
                c.getGuiControl().removeComponent(c);
            }
            if ((original = this.index.put(layer, c)) != null) {
                if (this.parent != null) {
                    original.detach(this.parent);
                }
                int index = this.components.indexOf((Object)original);
                this.components.set(index, c);
            } else {
                this.rebuildStack();
            }
            if (this.parent != null) {
                c.attach(this.parent);
                this.parent.invalidate();
            }
        } else {
            GuiComponent original = this.index.remove(layer);
            if (original != null) {
                this.removeComponent(original);
            }
        }
        return c;
    }

    public <T extends GuiComponent> T getComponent(String layer) {
        return (T)this.index.get(layer);
    }

    public <T extends GuiComponent> T removeComponent(String layer) {
        GuiComponent result = this.index.get(layer);
        if (result == null) {
            return null;
        }
        if (this.removeComponent(result)) {
            return (T)result;
        }
        return null;
    }

    public boolean removeComponent(GuiComponent c) {
        if (!this.components.remove((Object)c)) {
            return false;
        }
        this.index.values().remove(c);
        this.topList.remove(c);
        if (this.parent != null) {
            c.detach(this.parent);
            this.parent.invalidate();
        }
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[layerOrder=" + Arrays.asList(this.layerOrder) + "]";
    }
}

