/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.component;

import com.jme3.font.BitmapFont;
import com.jme3.font.BitmapText;
import com.jme3.font.Rectangle;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.HAlignment;
import com.simsilica.lemur.LayerComparator;
import com.simsilica.lemur.VAlignment;
import com.simsilica.lemur.component.AbstractGuiComponent;
import com.simsilica.lemur.component.ColoredComponent;
import com.simsilica.lemur.core.GuiControl;

public class TextComponent
extends AbstractGuiComponent
implements ColoredComponent {
    private BitmapText bitmapText;
    private Rectangle textBox;
    private HAlignment hAlign = HAlignment.Left;
    private VAlignment vAlign = VAlignment.Top;
    private Vector3f offset = null;
    private int layer;
    private float maxWidth;

    public TextComponent(String text, BitmapFont font) {
        this.bitmapText = new BitmapText(font);
        this.setText(text);
    }

    @Override
    public TextComponent clone() {
        TextComponent result = (TextComponent)super.clone();
        result.bitmapText = this.bitmapText.clone();
        result.textBox = null;
        return result;
    }

    @Override
    public void attach(GuiControl parent) {
        super.attach(parent);
        this.getNode().attachChild((Spatial)this.bitmapText);
    }

    @Override
    public void detach(GuiControl parent) {
        this.getNode().detachChild((Spatial)this.bitmapText);
        super.detach(parent);
    }

    public void setText(String text) {
        if (text != null && text.equals(this.bitmapText.getText())) {
            return;
        }
        this.bitmapText.setText(text);
        this.invalidate();
    }

    public String getText() {
        return this.bitmapText.getText();
    }

    public void setLayer(int layer) {
        if (this.layer == layer) {
            return;
        }
        this.layer = layer;
        this.resetLayer();
    }

    public int getLayer() {
        return this.layer;
    }

    public void setHAlignment(HAlignment a) {
        if (this.hAlign == a) {
            return;
        }
        this.hAlign = a;
        this.resetAlignment();
    }

    public HAlignment getHAlignment() {
        return this.hAlign;
    }

    public void setVAlignment(VAlignment a) {
        if (this.vAlign == a) {
            return;
        }
        this.vAlign = a;
        this.resetAlignment();
    }

    public VAlignment getVAlignment() {
        return this.vAlign;
    }

    public void setMaxWidth(float f) {
        this.maxWidth = f;
    }

    public float getMaxWidth() {
        return this.maxWidth;
    }

    public void setFont(BitmapFont font) {
        if (font == this.bitmapText.getFont()) {
            return;
        }
        if (this.isAttached()) {
            this.bitmapText.removeFromParent();
        }
        BitmapText newText = new BitmapText(font);
        newText.setText(this.getText());
        newText.setColor(this.getColor());
        newText.setLocalTranslation(this.bitmapText.getLocalTranslation());
        float currentSize = this.getFontSize();
        if (currentSize != this.bitmapText.getSize()) {
            newText.setSize(this.getFontSize());
        }
        this.bitmapText = newText;
        this.resetLayer();
        this.invalidate();
        if (this.isAttached()) {
            this.getNode().attachChild((Spatial)this.bitmapText);
        }
    }

    public BitmapFont getFont() {
        return this.bitmapText.getFont();
    }

    public void setFontSize(float size) {
        if (this.bitmapText.getSize() == size) {
            return;
        }
        this.bitmapText.setSize(size);
        this.invalidate();
    }

    public float getFontSize() {
        return this.bitmapText.getSize();
    }

    @Override
    public void setColor(ColorRGBA color) {
        float alpha = this.bitmapText.getAlpha();
        this.bitmapText.setColor(color);
        if (alpha != 1.0f) {
            this.bitmapText.setAlpha(alpha);
        }
    }

    @Override
    public ColorRGBA getColor() {
        return this.bitmapText.getColor();
    }

    @Override
    public void setAlpha(float f) {
        this.bitmapText.setAlpha(f);
    }

    @Override
    public float getAlpha() {
        return this.bitmapText.getAlpha();
    }

    public TextComponent color(ColorRGBA color) {
        this.setColor(color);
        return this;
    }

    public TextComponent offset(float x, float y, float z) {
        this.setOffset(x, y, z);
        return this;
    }

    public void setOffset(float x, float y, float z) {
        if (this.offset == null) {
            this.offset = new Vector3f(x, y, z);
        } else {
            this.offset.set(x, y, z);
        }
        this.invalidate();
    }

    public void setOffset(Vector3f offset) {
        this.offset = offset.clone();
        this.invalidate();
    }

    public Vector3f getOffset() {
        return this.offset;
    }

    public void setTextSize(float f) {
        this.bitmapText.setSize(f);
    }

    public float getTextSize() {
        return this.bitmapText.getSize();
    }

    @Override
    public void reshape(Vector3f pos, Vector3f size) {
        if (this.offset != null) {
            float effectiveZ = Math.max(0.0f, this.offset.z);
            this.bitmapText.setLocalTranslation(pos.x + this.offset.x, pos.y + this.offset.y, pos.z + effectiveZ);
            size.x -= Math.abs(this.offset.x);
            size.y -= Math.abs(this.offset.y);
            size.z -= Math.abs(this.offset.z);
            pos.z += Math.abs(this.offset.z);
        } else {
            this.bitmapText.setLocalTranslation(pos.x, pos.y, pos.z);
        }
        this.textBox = new Rectangle(0.0f, 0.0f, size.x, size.y);
        this.bitmapText.setBox(this.textBox);
        this.resetAlignment();
    }

    @Override
    public void calculatePreferredSize(Vector3f size) {
        this.bitmapText.setBox(null);
        if (this.maxWidth > 0.0f) {
            this.bitmapText.setBox(new Rectangle(0.0f, 0.0f, this.maxWidth, 0.0f));
        }
        size.x = this.bitmapText.getLineWidth();
        size.y = this.bitmapText.getHeight();
        if (this.offset != null) {
            size.x += Math.abs(this.offset.x);
            size.y += Math.abs(this.offset.y);
            size.z += Math.abs(this.offset.z);
        }
        size.x += 0.01f;
        this.bitmapText.setBox(this.textBox);
    }

    protected void resetAlignment() {
        if (this.textBox == null) {
            return;
        }
        switch (this.hAlign) {
            case Left: {
                this.bitmapText.setAlignment(BitmapFont.Align.Left);
                break;
            }
            case Right: {
                this.bitmapText.setAlignment(BitmapFont.Align.Right);
                break;
            }
            case Center: {
                this.bitmapText.setAlignment(BitmapFont.Align.Center);
            }
        }
        switch (this.vAlign) {
            case Top: {
                this.bitmapText.setVerticalAlignment(BitmapFont.VAlign.Top);
                break;
            }
            case Bottom: {
                this.bitmapText.setVerticalAlignment(BitmapFont.VAlign.Bottom);
                break;
            }
            case Center: {
                this.bitmapText.setVerticalAlignment(BitmapFont.VAlign.Center);
            }
        }
    }

    protected void resetLayer() {
        LayerComparator.resetLayer((Spatial)this.bitmapText, this.layer);
    }
}

