/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur;

import com.jme3.math.ColorRGBA;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Button;
import com.simsilica.lemur.Checkbox;
import com.simsilica.lemur.Command;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.component.BorderLayout;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.style.StyleAttribute;
import com.simsilica.lemur.style.Styles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TabbedPanel
extends Panel {
    public static final ElementId ELEMENT_ID = new ElementId("tabbedPanel");
    private BorderLayout layout;
    private Container tabButtons;
    private Container container;
    private List<Tab> tabs = new ArrayList<Tab>();
    private VersionedHolder<Tab> selectionModel = new VersionedHolder();
    private VersionedReference<Tab> selectionRef = this.selectionModel.createReference();
    private Tab displayedTab;
    private ColorRGBA activationColor = ColorRGBA.Cyan;

    public TabbedPanel() {
        this(true, ELEMENT_ID, null);
    }

    public TabbedPanel(String style) {
        this(true, ELEMENT_ID, style);
    }

    public TabbedPanel(ElementId elementId, String style) {
        this(true, elementId, style);
    }

    protected TabbedPanel(boolean applyStyles, ElementId elementId, String style) {
        super(false, elementId, style);
        this.layout = new BorderLayout();
        ((GuiControl)this.getControl(GuiControl.class)).setLayout(this.layout);
        this.tabButtons = new Container(new SpringGridLayout(Axis.X, Axis.Y, FillMode.None, FillMode.Even), elementId.child("tabButtons"), style);
        this.layout.addChild(this.tabButtons, new Object[]{BorderLayout.Position.North});
        this.container = new Container(new BorderLayout(), elementId.child("container"), style);
        this.layout.addChild(this.container, new Object[]{BorderLayout.Position.Center});
        if (applyStyles) {
            Styles styles = GuiGlobals.getInstance().getStyles();
            styles.applyStyles((Object)this, elementId, style);
        }
    }

    public <T extends Panel> T addTab(String title, T contents) {
        Tab tab = new Tab(title, contents);
        this.tabs.add(tab);
        this.refreshTabs();
        if (this.selectionModel.getObject() == null) {
            this.setSelectedTab(tab);
        }
        return contents;
    }

    public <T extends Panel> T insertTab(int index, String title, T contents) {
        Tab tab = new Tab(title, contents);
        this.tabs.add(index, tab);
        this.refreshTabs();
        if (this.selectionModel.getObject() == null) {
            this.setSelectedTab(tab);
        }
        return contents;
    }

    public Tab removeTab(Tab tab) {
        int index = this.tabs.indexOf(tab);
        if (index < 0) {
            return null;
        }
        if (this.selectionModel.getObject() == tab) {
            this.selectionModel.setObject(null);
        }
        this.tabs.remove(tab);
        this.refreshTabs();
        if (this.selectionModel.getObject() == null && !this.tabs.isEmpty()) {
            this.setSelectedTab(this.tabs.get(Math.min(index, this.tabs.size() - 1)));
        }
        return tab;
    }

    public List<Tab> getTabs() {
        return Collections.unmodifiableList(this.tabs);
    }

    public VersionedObject<Tab> getSelectionModel() {
        return this.selectionModel;
    }

    @StyleAttribute(value="activationColor", lookupDefault=false)
    public void setActivationColor(ColorRGBA color) {
        this.activationColor = color;
        if (this.displayedTab != null) {
            this.displayedTab.title.setColor(color);
        }
    }

    public ColorRGBA getActivationColor() {
        return this.activationColor;
    }

    protected void refreshTabs() {
        this.tabButtons.getLayout().clearChildren();
        for (Tab tab : this.tabs) {
            this.tabButtons.addChild(tab.title, new Object[0]);
        }
    }

    public void setSelectedTab(Tab tab) {
        if (!this.tabs.contains(tab)) {
            return;
        }
        this.selectionModel.updateObject(tab);
        this.setDisplayedTab(this.selectionModel.getObject());
    }

    public Tab getSelectedTab() {
        return this.selectionModel.getObject();
    }

    protected void setDisplayedTab(Tab tab) {
        if (this.displayedTab == tab) {
            return;
        }
        if (this.displayedTab != null) {
            this.displayedTab.removeContents();
        }
        this.displayedTab = tab;
        if (this.displayedTab != null) {
            this.displayedTab.addContents();
        }
        for (Tab t : this.tabs) {
            t.title.setChecked(t == tab);
        }
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.selectionRef != null && this.selectionRef.update()) {
            this.setDisplayedTab(this.selectionRef.get());
        }
    }

    protected class SwitchToTab
    implements Command<Button> {
        private Tab tab;

        public SwitchToTab(Tab tab) {
            this.tab = tab;
        }

        @Override
        public void execute(Button source) {
            TabbedPanel.this.setSelectedTab(this.tab);
        }
    }

    public class Tab {
        private Checkbox title;
        private Panel contents;
        private ColorRGBA originalColor;

        public Tab(String title, Panel contents) {
            this.title = new Checkbox(title, TabbedPanel.this.getElementId().child("tab.button"), TabbedPanel.this.getStyle());
            this.title.addClickCommands((Command<? super Button>)new SwitchToTab(this));
            this.contents = contents;
        }

        public String getTitle() {
            return this.title.getText();
        }

        public Checkbox getTitleButton() {
            return this.title;
        }

        public Panel getContents() {
            return this.contents;
        }

        protected void removeContents() {
            if (this.contents == null) {
                return;
            }
            if (this.contents.getParent() != null) {
                TabbedPanel.this.container.removeChild(this.contents);
                this.title.setColor(this.originalColor);
            }
        }

        protected void addContents() {
            if (this.contents == null) {
                return;
            }
            if (this.contents.getParent() == null) {
                TabbedPanel.this.container.addChild(this.contents, new Object[]{BorderLayout.Position.Center});
                this.originalColor = this.title.getColor();
                this.title.setColor(TabbedPanel.this.activationColor);
            }
        }
    }
}

