/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur;

import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.simsilica.lemur.Command;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.component.QuadBackgroundComponent;
import com.simsilica.lemur.core.CommandMap;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.event.DefaultMouseListener;
import com.simsilica.lemur.event.FocusMouseListener;
import com.simsilica.lemur.event.MouseEventControl;
import com.simsilica.lemur.focus.FocusChangeEvent;
import com.simsilica.lemur.focus.FocusChangeListener;
import com.simsilica.lemur.focus.FocusNavigationFunctions;
import com.simsilica.lemur.input.FunctionId;
import com.simsilica.lemur.input.InputState;
import com.simsilica.lemur.input.StateFunctionListener;
import com.simsilica.lemur.style.Attributes;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.style.StyleAttribute;
import com.simsilica.lemur.style.StyleDefaults;
import com.simsilica.lemur.style.Styles;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class Button
extends Label {
    public static final String ELEMENT_ID = "button";
    public static final String EFFECT_PRESS = "press";
    public static final String EFFECT_RELEASE = "release";
    public static final String EFFECT_CLICK = "click";
    public static final String EFFECT_ACTIVATE = "activate";
    public static final String EFFECT_DEACTIVATE = "deactivate";
    public static final String EFFECT_FOCUS = "focus";
    public static final String EFFECT_UNFOCUS = "unfocus";
    public static final String EFFECT_ENABLE = "enable";
    public static final String EFFECT_DISABLE = "disable";
    private boolean enabled = true;
    private ColorRGBA color;
    private ColorRGBA shadowColor;
    private ColorRGBA highlightColor;
    private ColorRGBA highlightShadowColor;
    private ColorRGBA focusColor;
    private ColorRGBA focusShadowColor;
    private boolean highlightOn;
    private boolean focusOn;
    private boolean pressed;
    private CommandMap<Button, ButtonAction> commandMap = new CommandMap(this);

    public Button(String s) {
        this(s, true, new ElementId(ELEMENT_ID), null);
    }

    public Button(String s, String style) {
        this(s, true, new ElementId(ELEMENT_ID), style);
    }

    public Button(String s, ElementId elementId) {
        this(s, true, elementId, null);
    }

    public Button(String s, ElementId elementId, String style) {
        this(s, true, elementId, style);
    }

    protected Button(String s, boolean applyStyles, ElementId elementId, String style) {
        super(s, false, elementId, style);
        this.addControl((Control)new MouseEventControl(FocusMouseListener.INSTANCE, new ButtonMouseHandler()));
        ((GuiControl)this.getControl(GuiControl.class)).addFocusChangeListener(new FocusObserver());
        ((GuiControl)this.getControl(GuiControl.class)).setFocusable(true);
        Styles styles = GuiGlobals.getInstance().getStyles();
        if (applyStyles) {
            styles.applyStyles((Object)this, elementId, style);
        }
    }

    @StyleDefaults(value="button")
    public static void initializeDefaultStyles(Attributes attrs) {
        GuiGlobals globals = GuiGlobals.getInstance();
        attrs.set("background", new QuadBackgroundComponent(new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f)), false);
        attrs.set("highlightColor", ColorRGBA.Yellow, false);
        attrs.set("focusColor", ColorRGBA.Green, false);
        attrs.set("shadowColor", globals.srgbaColor(new ColorRGBA(0.0f, 0.0f, 0.0f, 0.5f)), false);
    }

    public void addCommands(ButtonAction a, Command<? super Button> ... commands) {
        this.commandMap.addCommands(a, commands);
    }

    public List<Command<? super Button>> getCommands(ButtonAction a) {
        return this.commandMap.get(a, false);
    }

    public void addClickCommands(Command<? super Button> command) {
        this.commandMap.addCommands(ButtonAction.Click, (Command<Button>)command);
    }

    public void addClickCommands(Command<? super Button> ... commands) {
        this.commandMap.addCommands(ButtonAction.Click, commands);
    }

    public void removeClickCommands(Command<? super Button> ... commands) {
        this.getClickCommands().removeAll(Arrays.asList(commands));
    }

    public List<Command<? super Button>> getClickCommands() {
        return this.commandMap.get(ButtonAction.Click, false);
    }

    @StyleAttribute(value="buttonCommands")
    public void setButtonCommands(Map<ButtonAction, List<Command<? super Button>>> map) {
        this.commandMap.clear();
        for (Map.Entry<ButtonAction, List<Command<? super Button>>> e : map.entrySet()) {
            this.commandMap.addCommands(e.getKey(), (Collection<Command<Button>>)e.getValue());
        }
    }

    @Override
    @StyleAttribute(value="color")
    public void setColor(ColorRGBA color) {
        this.color = color;
        super.setColor(color);
    }

    @Override
    public ColorRGBA getColor() {
        return this.color;
    }

    @Override
    @StyleAttribute(value="shadowColor", lookupDefault=false)
    public void setShadowColor(ColorRGBA color) {
        this.shadowColor = color;
        super.setShadowColor(this.shadowColor);
    }

    @Override
    public ColorRGBA getShadowColor() {
        return this.shadowColor;
    }

    @StyleAttribute(value="highlightColor", lookupDefault=false)
    public void setHighlightColor(ColorRGBA color) {
        this.highlightColor = color;
        if (this.isHighlightOn()) {
            this.resetColors();
        }
    }

    public ColorRGBA getHighlightColor() {
        return this.highlightColor;
    }

    @StyleAttribute(value="highlightShadowColor", lookupDefault=false)
    public void setHighlightShadowColor(ColorRGBA color) {
        this.highlightShadowColor = color;
        if (this.isHighlightOn()) {
            this.resetColors();
        }
    }

    public ColorRGBA getHighlightShadowColor() {
        return this.highlightShadowColor;
    }

    @StyleAttribute(value="focusColor", lookupDefault=false)
    public void setFocusColor(ColorRGBA color) {
        this.focusColor = color;
        if (this.isFocusHighlightOn()) {
            this.resetColors();
        }
    }

    public ColorRGBA getFocusColor() {
        return this.focusColor;
    }

    @StyleAttribute(value="focusShadowColor", lookupDefault=false)
    public void setFocusShadowColor(ColorRGBA color) {
        this.focusShadowColor = color;
        if (this.isFocusHighlightOn()) {
            this.resetColors();
        }
    }

    public ColorRGBA getFocusShadowColor() {
        return this.focusShadowColor;
    }

    public void click() {
        this.runClick();
    }

    public void setEnabled(boolean b) {
        if (this.enabled == b) {
            return;
        }
        this.enabled = b;
        if (this.isEnabled()) {
            this.commandMap.runCommands(ButtonAction.Enabled);
            this.runEffect(EFFECT_ENABLE);
        } else {
            this.commandMap.runCommands(ButtonAction.Disabled);
            this.runEffect(EFFECT_DISABLE);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public boolean isHighlightOn() {
        return this.highlightOn;
    }

    public boolean isFocusHighlightOn() {
        return this.focusOn;
    }

    public boolean isFocused() {
        return ((GuiControl)this.getControl(GuiControl.class)).isFocused();
    }

    protected void showHighlight(boolean f) {
        this.highlightOn = f;
        this.resetColors();
    }

    protected void showFocus(boolean f) {
        this.focusOn = f;
        this.resetColors();
    }

    private static ColorRGBA mix(ColorRGBA c1, ColorRGBA c2) {
        if (c1 == null && c2 == null) {
            return null;
        }
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        return c1.clone().interpolateLocal(c2, 0.5f);
    }

    protected void resetColors() {
        if (this.focusOn && this.highlightOn) {
            ColorRGBA shadow;
            ColorRGBA color = Button.mix(this.getHighlightColor(), this.getFocusColor());
            if (color != null) {
                super.setColor(color);
            }
            if ((shadow = Button.mix(this.getHighlightShadowColor(), this.getFocusShadowColor())) != null) {
                super.setShadowColor(shadow);
            }
        } else if (this.highlightOn) {
            if (this.getHighlightColor() != null) {
                super.setColor(this.getHighlightColor());
            }
            if (this.getHighlightShadowColor() != null) {
                super.setShadowColor(this.getHighlightShadowColor());
            }
        } else if (this.focusOn) {
            if (this.getFocusColor() != null) {
                super.setColor(this.getFocusColor());
            }
            if (this.getFocusShadowColor() != null) {
                super.setShadowColor(this.getFocusShadowColor());
            }
        } else {
            super.setColor(this.getColor());
            super.setShadowColor(this.getShadowColor());
        }
    }

    protected void setPressed(boolean f) {
        if (this.pressed == f) {
            return;
        }
        this.pressed = f;
        if (this.pressed) {
            this.commandMap.runCommands(ButtonAction.Down);
            this.runEffect(EFFECT_PRESS);
        } else {
            this.commandMap.runCommands(ButtonAction.Up);
            this.runEffect(EFFECT_RELEASE);
        }
    }

    protected void runClick() {
        if (!this.isEnabled()) {
            return;
        }
        this.commandMap.runCommands(ButtonAction.Click);
        this.runEffect(EFFECT_CLICK);
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "[text=" + this.getText() + ", color=" + this.getColor() + ", elementId=" + this.getElementId() + "]";
    }

    protected class ButtonMouseHandler
    extends DefaultMouseListener {
        protected ButtonMouseHandler() {
        }

        @Override
        protected void click(MouseButtonEvent event, Spatial target, Spatial capture) {
        }

        @Override
        public void mouseButtonEvent(MouseButtonEvent event, Spatial target, Spatial capture) {
            event.setConsumed();
            if (!Button.this.isEnabled()) {
                return;
            }
            if (event.isPressed()) {
                Button.this.setPressed(event.isPressed());
            } else if (Button.this.isPressed()) {
                if (target == capture) {
                    Button.this.runClick();
                }
                if (capture == Button.this) {
                    Button.this.setPressed(false);
                }
            }
        }

        @Override
        public void mouseEntered(MouseMotionEvent event, Spatial target, Spatial capture) {
            if (!Button.this.isEnabled()) {
                return;
            }
            if (capture == Button.this || target == Button.this && capture == null) {
                Button.this.showHighlight(true);
                Button.this.commandMap.runCommands(ButtonAction.HighlightOn);
                Button.this.runEffect(Button.EFFECT_ACTIVATE);
            }
        }

        @Override
        public void mouseExited(MouseMotionEvent event, Spatial target, Spatial capture) {
            if (!Button.this.isHighlightOn()) {
                // empty if block
            }
            Button.this.showHighlight(false);
            Button.this.commandMap.runCommands(ButtonAction.HighlightOff);
            Button.this.runEffect(Button.EFFECT_DEACTIVATE);
        }

        @Override
        public void mouseMoved(MouseMotionEvent event, Spatial target, Spatial capture) {
            Button.this.commandMap.runCommands(ButtonAction.Hover);
        }
    }

    protected class FocusObserver
    implements FocusChangeListener,
    StateFunctionListener {
        protected FocusObserver() {
        }

        @Override
        public void focusGained(FocusChangeEvent event) {
            if (!Button.this.isEnabled()) {
                return;
            }
            Button.this.showFocus(true);
            Button.this.commandMap.runCommands(ButtonAction.FocusGained);
            Button.this.runEffect(Button.EFFECT_FOCUS);
            GuiGlobals.getInstance().getInputMapper().addStateListener(this, FocusNavigationFunctions.F_ACTIVATE);
        }

        @Override
        public void focusLost(FocusChangeEvent event) {
            if (!Button.this.isFocusHighlightOn()) {
                return;
            }
            GuiGlobals.getInstance().getInputMapper().removeStateListener(this, FocusNavigationFunctions.F_ACTIVATE);
            if (Button.this.isPressed()) {
                Button.this.setPressed(false);
            }
            Button.this.showFocus(false);
            Button.this.commandMap.runCommands(ButtonAction.FocusLost);
            Button.this.runEffect(Button.EFFECT_UNFOCUS);
        }

        @Override
        public void valueChanged(FunctionId func, InputState value, double tpf) {
            if (Button.this.pressed && value == InputState.Off) {
                Button.this.runClick();
            }
            Button.this.setPressed(Button.this.isEnabled() && value == InputState.Positive);
        }
    }

    public static enum ButtonAction {
        Down,
        Up,
        Click,
        HighlightOn,
        HighlightOff,
        FocusGained,
        FocusLost,
        Hover,
        Enabled,
        Disabled;

    }
}

