/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.ufop.util;

import com.qiwenshare.ufop.exception.UFOPException;
import com.qiwenshare.ufop.util.UFOPUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class CharsetUtils {
    public static byte[] convertTxtCharsetToGBK(byte[] bytes, String extendName) {
        if (Arrays.asList(UFOPUtils.TXT_FILE).contains(extendName)) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            try {
                String str = new String(bytes, CharsetUtils.getFileCharsetName(byteArrayInputStream));
                return str.getBytes("GBK");
            }
            catch (IOException e) {
                throw new UFOPException(e);
            }
        }
        return bytes;
    }

    public static byte[] convertTxtCharsetToUTF8(byte[] bytes, String extendName) {
        if (Arrays.asList(UFOPUtils.TXT_FILE).contains(extendName)) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            try {
                String str = new String(bytes, CharsetUtils.getFileCharsetName(byteArrayInputStream));
                return str.getBytes(StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new UFOPException(e);
            }
        }
        return bytes;
    }

    public static String getFileCharsetName(InputStream inputStream) {
        String charset = "GBK";
        byte[] first3Bytes = new byte[3];
        try {
            boolean checked = false;
            BufferedInputStream bis = new BufferedInputStream(inputStream);
            bis.mark(0);
            int read = bis.read(first3Bytes, 0, 3);
            if (read == -1) {
                bis.close();
                return charset;
            }
            if (first3Bytes[0] == -1 && first3Bytes[1] == -2) {
                charset = "UTF-16LE";
                checked = true;
            } else if (first3Bytes[0] == -2 && first3Bytes[1] == -1) {
                charset = "UTF-16BE";
                checked = true;
            } else if (first3Bytes[0] == -17 && first3Bytes[1] == -69 && first3Bytes[2] == -65) {
                charset = "UTF-8";
                checked = true;
            }
            bis.reset();
            if (!checked) {
                while ((read = bis.read()) != -1 && read < 240 && (128 > read || read > 191)) {
                    if (192 <= read && read <= 223) {
                        read = bis.read();
                        if (128 > read || read > 191) break;
                        continue;
                    }
                    if (224 > read || read > 239) continue;
                    read = bis.read();
                    if (128 > read || read > 191 || 128 > (read = bis.read()) || read > 191) break;
                    charset = "UTF-8";
                    break;
                }
            }
            bis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return charset;
    }

    public static void main(String[] args) {
        System.out.println(Charset.forName("GB2312").newEncoder().canEncode("\u00ce\u00c4\u00bc\u00fe\u00bc\u00d0\u00d1\u00b9\u00cb\u00f5"));
        System.out.println(StandardCharsets.ISO_8859_1.newEncoder().canEncode("\u00ce\u00c4\u00bc\u00fe\u00bc\u00d0\u00d1\u00b9\u00cb\u00f5"));
        System.out.println(StandardCharsets.UTF_8.newEncoder().canEncode("\u00ce\u00c4\u00bc\u00fe\u00bc\u00d0\u00d1\u00b9\u00cb\u00f5"));
        System.out.println(StandardCharsets.US_ASCII.newEncoder().canEncode("\u00ce\u00c4\u00bc\u00fe\u00bc\u00d0\u00d1\u00b9\u00cb\u00f5"));
        byte[] e = "\u00ce\u00c4\u00bc\u00fe\u00bc\u00d0\u00d1\u00b9\u00cb\u00f5".getBytes(StandardCharsets.ISO_8859_1);
        try {
            System.out.println(new String("\u00ce\u00c4\u00bc\u00fe\u00bc\u00d0\u00d1\u00b9\u00cb\u00f5".getBytes("GBK"), "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        System.out.println(CharsetUtils.getFileCharsetName(new ByteArrayInputStream("\u00ce\u00c4\u00bc\u00fe\u00bc\u00d0\u00d1\u00b9\u00cb\u00f5".getBytes())));
    }
}

