/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.ufop.operation.write.product;

import com.google.gson.Gson;
import com.qiniu.http.Response;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Recorder;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.model.DefaultPutRet;
import com.qiniu.storage.persistent.FileRecorder;
import com.qiniu.util.Auth;
import com.qiwenshare.ufop.config.QiniuyunConfig;
import com.qiwenshare.ufop.exception.operation.WriteException;
import com.qiwenshare.ufop.operation.write.Writer;
import com.qiwenshare.ufop.operation.write.domain.WriteFile;
import com.qiwenshare.ufop.util.QiniuyunUtils;
import com.qiwenshare.ufop.util.UFOPUtils;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QiniuyunKodoWriter
extends Writer {
    private static final Logger log = LoggerFactory.getLogger(QiniuyunKodoWriter.class);
    private QiniuyunConfig qiniuyunConfig;

    public QiniuyunKodoWriter() {
    }

    public QiniuyunKodoWriter(QiniuyunConfig qiniuyunConfig) {
        this.qiniuyunConfig = qiniuyunConfig;
    }

    @Override
    public void write(InputStream inputStream, WriteFile writeFile) {
        this.qiniuUpload(writeFile.getFileUrl(), inputStream);
    }

    private void qiniuUpload(String fileUrl, InputStream inputStream) {
        Configuration cfg = QiniuyunUtils.getCfg(this.qiniuyunConfig);
        Auth auth = Auth.create((String)this.qiniuyunConfig.getKodo().getAccessKey(), (String)this.qiniuyunConfig.getKodo().getSecretKey());
        String upToken = auth.uploadToken(this.qiniuyunConfig.getKodo().getBucketName(), fileUrl);
        String localTempDir = UFOPUtils.getStaticPath() + "temp";
        try {
            FileRecorder fileRecorder = new FileRecorder(localTempDir);
            UploadManager uploadManager = new UploadManager(cfg, (Recorder)fileRecorder);
            Response response = uploadManager.put(inputStream, fileUrl, upToken, null, null);
            DefaultPutRet putRet = (DefaultPutRet)new Gson().fromJson(response.bodyString(), DefaultPutRet.class);
            log.info(putRet.key);
            log.info(putRet.hash);
        }
        catch (IOException ex) {
            throw new WriteException("\u4e03\u725b\u4e91\u5199\u6587\u4ef6\u5931\u8d25\uff01", ex);
        }
    }
}

