/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.ufop.operation.read.product;

import com.github.tobato.fastdfs.proto.storage.DownloadByteArray;
import com.github.tobato.fastdfs.proto.storage.DownloadCallback;
import com.github.tobato.fastdfs.service.FastFileStorageClient;
import com.qiwenshare.ufop.exception.operation.ReadException;
import com.qiwenshare.ufop.operation.read.Reader;
import com.qiwenshare.ufop.operation.read.domain.ReadFile;
import com.qiwenshare.ufop.util.ReadFileUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FastDFSReader
extends Reader {
    private static final Logger log = LoggerFactory.getLogger(FastDFSReader.class);
    @Autowired
    private FastFileStorageClient fastFileStorageClient;

    @Override
    public String read(ReadFile readFile) {
        String fileUrl = readFile.getFileUrl();
        String fileType = FilenameUtils.getExtension((String)fileUrl);
        try {
            return ReadFileUtils.getContentByInputStream(fileType, this.getInputStream(readFile.getFileUrl()));
        }
        catch (IOException e) {
            throw new ReadException("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25", e);
        }
    }

    public InputStream getInputStream(String fileUrl) {
        String group = "group1";
        String path = fileUrl.substring(fileUrl.indexOf("/") + 1);
        DownloadByteArray downloadByteArray = new DownloadByteArray();
        byte[] bytes = (byte[])this.fastFileStorageClient.downloadFile(group, path, (DownloadCallback)downloadByteArray);
        return new ByteArrayInputStream(bytes);
    }
}

