/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.ufop.operation.preview;

import cn.hutool.http.HttpUtil;
import com.qiwenshare.common.operation.ImageOperation;
import com.qiwenshare.ufop.domain.ThumbImage;
import com.qiwenshare.ufop.exception.operation.PreviewException;
import com.qiwenshare.ufop.operation.preview.domain.PreviewFile;
import com.qiwenshare.ufop.util.CharsetUtils;
import com.qiwenshare.ufop.util.UFOPUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Previewer {
    private static final Logger log = LoggerFactory.getLogger(Previewer.class);
    public ThumbImage thumbImage;

    protected abstract InputStream getInputStream(PreviewFile var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void imageThumbnailPreview(HttpServletResponse httpServletResponse, PreviewFile previewFile) {
        block29: {
            File cacheFile;
            block32: {
                String fileUrl;
                block30: {
                    block28: {
                        File cacheFile2;
                        String icoUrl;
                        block31: {
                            fileUrl = previewFile.getFileUrl();
                            if (!fileUrl.startsWith("http://") && !fileUrl.startsWith("https://")) break block30;
                            String[] arr = fileUrl.replace("http://", "").replace("https://", "").split("/");
                            String name = arr[0];
                            icoUrl = Previewer.findIco(fileUrl);
                            cacheFile2 = UFOPUtils.getCacheFile(UFOPUtils.getUploadFileUrl(name, "ico"));
                            if (!cacheFile2.exists()) break block31;
                            FileInputStream fis = null;
                            ServletOutputStream outputStream = null;
                            try {
                                fis = new FileInputStream(cacheFile2);
                                outputStream = httpServletResponse.getOutputStream();
                                IOUtils.copy((InputStream)fis, (OutputStream)outputStream);
                            }
                            catch (IOException e) {
                                try {
                                    e.printStackTrace();
                                }
                                catch (Throwable throwable) {
                                    IOUtils.closeQuietly(fis);
                                    IOUtils.closeQuietly(outputStream);
                                    throw throwable;
                                }
                                IOUtils.closeQuietly((InputStream)fis);
                                IOUtils.closeQuietly((OutputStream)outputStream);
                                break block28;
                            }
                            IOUtils.closeQuietly((InputStream)fis);
                            IOUtils.closeQuietly((OutputStream)outputStream);
                            break block28;
                        }
                        URL url = null;
                        InputStream in = null;
                        ServletOutputStream outputStream = null;
                        try {
                            url = new URL(icoUrl);
                            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                            InputStream inputstream = connection.getInputStream();
                            try {
                                outputStream = httpServletResponse.getOutputStream();
                                in = ImageOperation.thumbnailsImageForScale((InputStream)inputstream, (File)cacheFile2, (long)50L);
                                IOUtils.copy((InputStream)in, (OutputStream)outputStream);
                                IOUtils.closeQuietly((InputStream)in);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                break block28;
                            }
                            finally {
                                IOUtils.closeQuietly(in);
                                IOUtils.closeQuietly((InputStream)inputstream);
                                IOUtils.closeQuietly((OutputStream)outputStream);
                                if (previewFile.getOssClient() != null) {
                                    previewFile.getOssClient().shutdown();
                                }
                            }
                            IOUtils.closeQuietly((InputStream)inputstream);
                            IOUtils.closeQuietly((OutputStream)outputStream);
                            if (previewFile.getOssClient() != null) {
                                previewFile.getOssClient().shutdown();
                            }
                        }
                        catch (MalformedURLException e) {
                            log.error("MalformedURLException, url is {}", (Object)icoUrl);
                            throw new RuntimeException(e);
                        }
                        catch (IOException e) {
                            log.error("IOException, url is {}", (Object)icoUrl);
                            throw new RuntimeException(e);
                        }
                    }
                    return;
                }
                boolean isVideo = UFOPUtils.isVideoFile(FilenameUtils.getExtension((String)fileUrl));
                String thumbnailImgUrl = previewFile.getFileUrl();
                if (isVideo) {
                    thumbnailImgUrl = fileUrl.replace("." + FilenameUtils.getExtension((String)fileUrl), ".jpg");
                }
                if (!(cacheFile = UFOPUtils.getCacheFile(thumbnailImgUrl)).exists()) break block32;
                FileInputStream fis = null;
                ServletOutputStream outputStream = null;
                try {
                    fis = new FileInputStream(cacheFile);
                    outputStream = httpServletResponse.getOutputStream();
                    IOUtils.copy((InputStream)fis, (OutputStream)outputStream);
                }
                catch (IOException e) {
                    try {
                        e.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fis);
                        IOUtils.closeQuietly(outputStream);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)fis);
                    IOUtils.closeQuietly((OutputStream)outputStream);
                    break block29;
                }
                IOUtils.closeQuietly((InputStream)fis);
                IOUtils.closeQuietly((OutputStream)outputStream);
                break block29;
            }
            ServletOutputStream outputStream = null;
            InputStream in = null;
            InputStream inputstream = null;
            try {
                inputstream = this.getInputStream(previewFile);
            }
            catch (PreviewException previewException) {
                log.error(previewException.getMessage());
                return;
            }
            try {
                outputStream = httpServletResponse.getOutputStream();
                in = ImageOperation.thumbnailsImageForScale((InputStream)inputstream, (File)cacheFile, (long)50L);
                IOUtils.copy((InputStream)in, (OutputStream)outputStream);
                IOUtils.closeQuietly((InputStream)in);
            }
            catch (IOException e) {
                e.printStackTrace();
                break block29;
            }
            finally {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly((InputStream)inputstream);
                IOUtils.closeQuietly((OutputStream)outputStream);
                if (previewFile.getOssClient() != null) {
                    previewFile.getOssClient().shutdown();
                }
            }
            IOUtils.closeQuietly((InputStream)inputstream);
            IOUtils.closeQuietly((OutputStream)outputStream);
            if (previewFile.getOssClient() != null) {
                previewFile.getOssClient().shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void imageOriginalPreview(HttpServletResponse httpServletResponse, PreviewFile previewFile) {
        InputStream inputStream = null;
        ServletOutputStream outputStream = null;
        try {
            inputStream = this.getInputStream(previewFile);
            outputStream = httpServletResponse.getOutputStream();
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            bytes = CharsetUtils.convertTxtCharsetToUTF8(bytes, FilenameUtils.getExtension((String)previewFile.getFileUrl()));
            outputStream.write(bytes);
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)inputStream);
                IOUtils.closeQuietly(outputStream);
                if (previewFile.getOssClient() != null) {
                    previewFile.getOssClient().shutdown();
                }
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)outputStream);
            if (previewFile.getOssClient() != null) {
                previewFile.getOssClient().shutdown();
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
        if (previewFile.getOssClient() != null) {
            previewFile.getOssClient().shutdown();
        }
    }

    private static String findIco(String navUrl) {
        String body = HttpUtil.createGet((String)navUrl).execute().toString();
        String str = body.split("favicon\\d{0,3}.ico")[0];
        int http = str.indexOf("https://", str.length() - 100);
        if (http == -1) {
            http = str.indexOf("http://", str.length() - 100);
        }
        if (http == -1) {
            int i = navUrl.indexOf("/", 8);
            if (i > 0) {
                navUrl = navUrl.substring(0, i);
            }
        } else {
            navUrl = str.substring(http);
        }
        return navUrl + "/favicon.ico";
    }

    public ThumbImage getThumbImage() {
        return this.thumbImage;
    }

    public void setThumbImage(ThumbImage thumbImage) {
        this.thumbImage = thumbImage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Previewer)) {
            return false;
        }
        Previewer other = (Previewer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ThumbImage this$thumbImage = this.getThumbImage();
        ThumbImage other$thumbImage = other.getThumbImage();
        return !(this$thumbImage == null ? other$thumbImage != null : !((Object)this$thumbImage).equals(other$thumbImage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Previewer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ThumbImage $thumbImage = this.getThumbImage();
        result = result * 59 + ($thumbImage == null ? 43 : ((Object)$thumbImage).hashCode());
        return result;
    }

    public String toString() {
        return "Previewer(thumbImage=" + this.getThumbImage() + ")";
    }
}

