/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.ufop.operation.download.product;

import com.aliyun.oss.OSS;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.qiwenshare.ufop.config.AliyunConfig;
import com.qiwenshare.ufop.operation.download.Downloader;
import com.qiwenshare.ufop.operation.download.domain.DownloadFile;
import com.qiwenshare.ufop.util.AliyunUtils;
import com.qiwenshare.ufop.util.UFOPUtils;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunOSSDownloader
extends Downloader {
    private static final Logger log = LoggerFactory.getLogger(AliyunOSSDownloader.class);
    private AliyunConfig aliyunConfig;

    public AliyunOSSDownloader() {
    }

    public AliyunOSSDownloader(AliyunConfig aliyunConfig) {
        this.aliyunConfig = aliyunConfig;
    }

    @Override
    public InputStream getInputStream(DownloadFile downloadFile) {
        OSSObject ossObject;
        OSS ossClient = AliyunUtils.getOSSClient(this.aliyunConfig);
        if (downloadFile.getRange() != null) {
            GetObjectRequest getObjectRequest = new GetObjectRequest(this.aliyunConfig.getOss().getBucketName(), UFOPUtils.getAliyunObjectNameByFileUrl(downloadFile.getFileUrl()));
            getObjectRequest.setRange(downloadFile.getRange().getStart(), downloadFile.getRange().getStart() + (long)downloadFile.getRange().getLength() - 1L);
            ossObject = ossClient.getObject(getObjectRequest);
        } else {
            ossObject = ossClient.getObject(this.aliyunConfig.getOss().getBucketName(), UFOPUtils.getAliyunObjectNameByFileUrl(downloadFile.getFileUrl()));
        }
        InputStream inputStream = ossObject.getObjectContent();
        downloadFile.setOssClient(ossClient);
        return inputStream;
    }
}

