/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.plugin.ureport.provider;

import com.amazonaws.services.s3.model.S3Object;
import com.bstek.ureport.provider.report.ReportFile;
import com.bstek.ureport.provider.report.ReportProvider;
import com.pig4cloud.plugin.oss.OssProperties;
import com.pig4cloud.plugin.oss.service.OssTemplate;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DfsReportProvider
implements ReportProvider {
    private static final Logger log = LoggerFactory.getLogger(DfsReportProvider.class);
    private static final String PREFIX = "oss_";
    private final OssTemplate ossTemplate;
    private final OssProperties properties;

    public InputStream loadReport(String file) {
        S3Object object = this.ossTemplate.getObject(this.properties.getBucketName(), file);
        return object.getObjectContent();
    }

    public void deleteReport(String file) {
        try {
            this.ossTemplate.removeObject(this.properties.getBucketName(), file);
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u5220\u9664\u5931\u8d25 ", (Throwable)e);
        }
    }

    public List<ReportFile> getReportFiles() {
        List objectSummaryList = this.ossTemplate.getAllObjectsByPrefix(this.properties.getBucketName(), PREFIX, true);
        return objectSummaryList.stream().map(s3ObjectSummary -> new ReportFile(s3ObjectSummary.getKey().replaceAll(PREFIX, ""), s3ObjectSummary.getLastModified())).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveReport(String file, String content) {
        try {
            InputStream inputStream = IOUtils.toInputStream((String)content);
            try {
                this.ossTemplate.putObject(this.properties.getBucketName(), file, inputStream);
            }
            finally {
                if (Collections.singletonList(inputStream).get(0) != null) {
                    inputStream.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
        }
    }

    public String getName() {
        return "\u5206\u5e03\u5f0f\u6587\u4ef6\u5b58\u50a8";
    }

    public boolean disabled() {
        return false;
    }

    public String getPrefix() {
        return PREFIX;
    }

    public DfsReportProvider(OssTemplate ossTemplate, OssProperties properties) {
        this.ossTemplate = ossTemplate;
        this.properties = properties;
    }
}

