/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license.git;

import com.mycila.maven.plugin.license.AbstractLicenseMojo;
import com.mycila.maven.plugin.license.PropertiesProvider;
import com.mycila.maven.plugin.license.document.Document;
import com.mycila.maven.plugin.license.git.GitLookup;
import com.mycila.maven.plugin.license.git.GitPropertiesProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class CopyrightRangeProvider
extends GitPropertiesProvider
implements PropertiesProvider {
    public static final String COPYRIGHT_LAST_YEAR_KEY = "license.git.copyrightLastYear";
    public static final String COPYRIGHT_CREATION_YEAR_KEY = "license.git.copyrightCreationYear";
    public static final String COPYRIGHT_YEARS_KEY = "license.git.copyrightYears";
    public static final String INCEPTION_YEAR_KEY = "project.inceptionYear";

    public Map<String, String> getAdditionalProperties(AbstractLicenseMojo mojo, Properties properties, Document document) {
        int inceptionYearInt;
        String inceptionYear = properties.getProperty(INCEPTION_YEAR_KEY);
        if (inceptionYear == null) {
            throw new RuntimeException("'project.inceptionYear' must have a value for file " + document.getFile().getAbsolutePath());
        }
        try {
            inceptionYearInt = Integer.parseInt(inceptionYear);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException("'project.inceptionYear' must be an integer ; found = " + inceptionYear + " file: " + document.getFile().getAbsolutePath());
        }
        try {
            HashMap<String, String> result = new HashMap<String, String>(4);
            GitLookup gitLookup = this.getGitLookup(document.getFile(), properties);
            int copyrightEnd = gitLookup.getYearOfLastChange(document.getFile());
            result.put(COPYRIGHT_LAST_YEAR_KEY, Integer.toString(copyrightEnd));
            String copyrightYears = inceptionYearInt >= copyrightEnd ? inceptionYear : String.valueOf(inceptionYear) + "-" + copyrightEnd;
            result.put(COPYRIGHT_YEARS_KEY, copyrightYears);
            int copyrightStart = gitLookup.getYearOfCreation(document.getFile());
            result.put(COPYRIGHT_CREATION_YEAR_KEY, Integer.toString(copyrightStart));
            return Collections.unmodifiableMap(result);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not compute the year of the last git commit for file " + document.getFile().getAbsolutePath(), e);
        }
    }
}

