/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.wechat.utils;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.common.collect.Lists;
import com.kuaike.common.entity.WechatMessage;
import com.kuaike.skynet.logic.wechat.msg.JoinGroupMsg;
import com.kuaike.skynet.logic.wechat.utils.JoinGroupDto;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JoinGroupFactory {
    private static final Logger log = LoggerFactory.getLogger(JoinGroupFactory.class);
    public static final XmlMapper xmlMapper = new XmlMapper();

    private JoinGroupFactory() {
    }

    public static JoinGroupDto parse(WechatMessage wechatMessage) {
        JoinGroupMsg.Member me = new JoinGroupMsg.Member();
        me.setUsername(wechatMessage.getWechatId());
        me.setNickname(wechatMessage.getNickName());
        String message = wechatMessage.getMessage();
        String start = "<sysmsg";
        String end = "</sysmsg>";
        int startIdx = message.indexOf(start);
        int endIdx = message.indexOf(end);
        if (startIdx < 0 || endIdx < 0) {
            log.warn("\u6d88\u606f\u5185\u5bb9\u683c\u5f0f\u9519\u8bef\uff0c\u65e0\u6cd5\u89e3\u6790, requestId={}", (Object)wechatMessage.getRequestId());
            return null;
        }
        String xml = message.substring(startIdx, endIdx + end.length());
        JoinGroupMsg msg = null;
        try {
            msg = (JoinGroupMsg)xmlMapper.readValue(xml, JoinGroupMsg.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("\u6d88\u606f\u89e3\u6790\u5931\u8d25, requestId:{}", (Object)wechatMessage.getRequestId(), (Object)e);
            return null;
        }
        Parser parser = JoinGroupFactory.getParser(msg.getSysMsgTemplate().getContentTemplate().getTemplate());
        if (parser == null) {
            log.info("Not join group msg, template={}", (Object)msg.getSysMsgTemplate().getContentTemplate().getTemplate());
            return null;
        }
        try {
            return parser.parse(me, msg);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Parse join group message failed, xml={}", (Object)xml, (Object)e);
            return null;
        }
    }

    private static Parser getParser(String template) {
        if (StringUtils.isBlank((CharSequence)template)) {
            return null;
        }
        switch (template) {
            case "\"$username$\"\u9080\u8bf7\u4f60\u548c\"$names$\"\u52a0\u5165\u4e86\u7fa4\u804a": 
            case "\u300c$username$\u300d\u9080\u8acb\u4f60\u548c$names$\u52a0\u5165\u4e86\u7fa4\u7d44": 
            case "invited you and $names$ to the group chat": {
                return JoinGroupFactory.invitedYouAndOthers();
            }
            case "\"$username$\"\u9080\u8bf7\"$names$\"\u52a0\u5165\u4e86\u7fa4\u804a": 
            case "\u300c$username$\u300d\u9080\u8acb\u300c$names$\u300d\u52a0\u5165\u4e86\u7fa4\u7d44": 
            case "$username$ invited $names$ to the group chat": {
                return JoinGroupFactory.invitedOthers();
            }
            case "\u4f60\u9080\u8bf7\"$names$\"\u52a0\u5165\u4e86\u7fa4\u804a  $revoke$": 
            case "\u4f60\u9080\u8acb\u300c$names$\u300d\u52a0\u5165\u4e86\u7fa4\u7d44  $revoke$": 
            case "You invited $names$ to the group chat.   $revoke$": {
                return JoinGroupFactory.youInvitedOthers();
            }
            case "\"$username$\"\u9080\u8bf7\u4f60\u52a0\u5165\u4e86\u7fa4\u804a\uff0c\u7fa4\u804a\u53c2\u4e0e\u4eba\u8fd8\u6709\uff1a$others$": 
            case "\u300c$username$\u300d\u9080\u8acb\u4f60\u52a0\u5165\u4e86\u7fa4\u7d44\uff0c\u6210\u54e1\u9084\u6709\uff1a$others$": 
            case "$username$ invited you to a group chat with $others$": {
                return JoinGroupFactory.invitedYou();
            }
            case "\"$username$\"\u9080\u8bf7\u4f60\u52a0\u5165\u4e86\u7fa4\u804a": 
            case "\u300c$username$\u300d\u9080\u8acb\u4f60\u52a0\u5165\u4e86\u7fa4\u7d44": 
            case "$username$ invited you to the group chat": {
                return JoinGroupFactory.invitedYou();
            }
            case "\"$adder$\"\u901a\u8fc7\u626b\u63cf\u4f60\u5206\u4eab\u7684\u4e8c\u7ef4\u7801\u52a0\u5165\u7fa4\u804a  $revoke$": 
            case "\u300c$adder$\u300d\u900f\u904e\u6383\u63cf\u4f60\u5206\u4eab\u7684QR code\u52a0\u5165\u7fa4\u7d44  $revoke$": 
            case "\"$adder$\" joined group chat via the QR code you shared.  $revoke$": {
                return JoinGroupFactory.scanYourQrcode();
            }
            case "\"$adder$\"\u901a\u8fc7\u626b\u63cf\"$from$\"\u5206\u4eab\u7684\u4e8c\u7ef4\u7801\u52a0\u5165\u7fa4\u804a": 
            case "\u300c$adder$\u300d\u900f\u904e\u6383\u63cf\u300c$from$\u300d\u5206\u4eab\u7684QR Code\u52a0\u5165\u7fa4\u7d44\u3002": 
            case "\"$adder$\" joined the group chat via the QR Code shared by \"$from$\".": {
                return JoinGroupFactory.scanQrcode();
            }
            case "\"$names$\"\u52a0\u5165\u4e86\u7fa4\u804a": 
            case "\u300c$names$\u300d\u52a0\u5165\u4e86\u7fa4\u7d44": 
            case "\"$names$\" joined the group chat.": {
                return JoinGroupFactory.create();
            }
        }
        return null;
    }

    private static Parser invitedYouAndOthers() {
        return new Parser(){

            @Override
            public JoinGroupDto parse(JoinGroupMsg.Member me, JoinGroupMsg msg) {
                List<JoinGroupMsg.Link> linklist = msg.getSysMsgTemplate().getContentTemplate().getLinklist();
                JoinGroupMsg.Member inviteMember = null;
                List<JoinGroupMsg.Member> memberList = null;
                for (JoinGroupMsg.Link link : linklist) {
                    if ("username".equals(link.getName())) {
                        inviteMember = link.getMemberList().get(0);
                        continue;
                    }
                    if (!"names".equals(link.getName())) continue;
                    memberList = link.getMemberList();
                    memberList.add(me);
                }
                return new JoinGroupDto(1, inviteMember, memberList);
            }
        };
    }

    private static Parser invitedOthers() {
        return new Parser(){

            @Override
            public JoinGroupDto parse(JoinGroupMsg.Member me, JoinGroupMsg msg) {
                List<JoinGroupMsg.Link> linklist = msg.getSysMsgTemplate().getContentTemplate().getLinklist();
                JoinGroupMsg.Member inviter = null;
                List<JoinGroupMsg.Member> memberList = null;
                for (JoinGroupMsg.Link link : linklist) {
                    if ("username".equals(link.getName())) {
                        inviter = link.getMemberList().get(0);
                        continue;
                    }
                    if (!"names".equals(link.getName())) continue;
                    memberList = link.getMemberList();
                }
                return new JoinGroupDto(1, inviter, memberList);
            }
        };
    }

    private static Parser youInvitedOthers() {
        return new Parser(){

            @Override
            public JoinGroupDto parse(JoinGroupMsg.Member me, JoinGroupMsg msg) {
                List<JoinGroupMsg.Link> linklist = msg.getSysMsgTemplate().getContentTemplate().getLinklist();
                JoinGroupMsg.Member inviter = me;
                List<JoinGroupMsg.Member> memberList = null;
                for (JoinGroupMsg.Link link : linklist) {
                    if (!"names".equals(link.getName())) continue;
                    memberList = link.getMemberList();
                }
                return new JoinGroupDto(1, inviter, memberList);
            }
        };
    }

    private static Parser invitedYou() {
        return new Parser(){

            @Override
            public JoinGroupDto parse(JoinGroupMsg.Member me, JoinGroupMsg msg) {
                List<JoinGroupMsg.Link> linklist = msg.getSysMsgTemplate().getContentTemplate().getLinklist();
                JoinGroupMsg.Member inviter = null;
                ArrayList memberList = Lists.newArrayList((Object[])new JoinGroupMsg.Member[]{me});
                for (JoinGroupMsg.Link link : linklist) {
                    if (!"username".equals(link.getName())) continue;
                    inviter = link.getMemberList().get(0);
                }
                return new JoinGroupDto(1, inviter, memberList);
            }
        };
    }

    private static Parser scanYourQrcode() {
        return new Parser(){

            @Override
            public JoinGroupDto parse(JoinGroupMsg.Member me, JoinGroupMsg msg) {
                List<JoinGroupMsg.Link> linklist = msg.getSysMsgTemplate().getContentTemplate().getLinklist();
                JoinGroupMsg.Member inviter = me;
                List<JoinGroupMsg.Member> memberList = null;
                for (JoinGroupMsg.Link link : linklist) {
                    if (!"adder".equals(link.getName())) continue;
                    memberList = link.getMemberList();
                }
                return new JoinGroupDto(2, inviter, memberList);
            }
        };
    }

    private static Parser scanQrcode() {
        return new Parser(){

            @Override
            public JoinGroupDto parse(JoinGroupMsg.Member me, JoinGroupMsg msg) {
                List<JoinGroupMsg.Link> linklist = msg.getSysMsgTemplate().getContentTemplate().getLinklist();
                JoinGroupMsg.Member inviter = null;
                List<JoinGroupMsg.Member> memberList = null;
                for (JoinGroupMsg.Link link : linklist) {
                    if ("adder".equals(link.getName())) {
                        memberList = link.getMemberList();
                        continue;
                    }
                    if (!"from".equals(link.getName())) continue;
                    inviter = link.getMemberList().get(0);
                }
                return new JoinGroupDto(2, inviter, memberList);
            }
        };
    }

    private static Parser create() {
        return new Parser(){

            @Override
            public JoinGroupDto parse(JoinGroupMsg.Member me, JoinGroupMsg msg) {
                List<JoinGroupMsg.Link> linklist = msg.getSysMsgTemplate().getContentTemplate().getLinklist();
                JoinGroupMsg.Member inviter = me;
                List<JoinGroupMsg.Member> memberList = null;
                for (JoinGroupMsg.Link link : linklist) {
                    if (!"names".equals(link.getName())) continue;
                    memberList = link.getMemberList();
                }
                return new JoinGroupDto(3, inviter, memberList);
            }
        };
    }

    static {
        xmlMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    static interface Parser {
        public JoinGroupDto parse(JoinGroupMsg.Member var1, JoinGroupMsg var2);
    }
}

