/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package com.kuaike.skynet.logic.wechat.msg;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

import lombok.Data;

/**
 * 个人名片/公众号名片
 * @title VisitingCard
 * @author yanmaoyuan
 * @date 2019年12月11日
 * @version 1.0
 */
@Data
@JacksonXmlRootElement(localName = "msg")
public class VisitingCard {

    @JacksonXmlProperty(localName = "bigheadimgurl", isAttribute = true)
    private String bigHeadImgUrl;// 头像大图url

    @JacksonXmlProperty(localName = "smallheadimgurl", isAttribute = true)
    private String smallHeadImgUrl;// 头像小图url

    /**
     * 公众号名片中，这是公众号的user那么，如:gh_c15943537dbb
     * 
     * 个人名片中，这是一个加密的字符串，如:
     * v1_ce7970a3b5ada1b85e3b6c654f41fff61782696b088ee1515d77ce7aecf0d576b8df3c527fdf57c6c0867633ae17e5ef@stranger
     */
    @JacksonXmlProperty(isAttribute = true)
    private String username;

    @JacksonXmlProperty(isAttribute = true)
    private String nickname;

    /**
     * 名字的拼音，如zhangsan
     */
    @JacksonXmlProperty(isAttribute = true)
    private String fullpy;

    /**
     * 名字拼音首字母的缩写，如ZS
     */
    private String shortpy;

    /**
     * 微信号的别名
     */
    @JacksonXmlProperty(isAttribute = true)
    private String alias;

    @JacksonXmlProperty(localName = "imagestatus", isAttribute = true)
    private String imageStatus;// int

    @JacksonXmlProperty(isAttribute = true)
    private Integer scene;// int

    @JacksonXmlProperty(isAttribute = true)
    private String province;

    @JacksonXmlProperty(isAttribute = true)
    private String city;

    /**
     * 微信用户的个性签名
     */
    @JacksonXmlProperty(isAttribute = true)
    private String sign;

    @JacksonXmlProperty(isAttribute = true)
    private Integer sex;

    @JacksonXmlProperty(localName = "certflag", isAttribute = true)
    private Integer certFlag;
    
    @JacksonXmlProperty(localName = "certinfo", isAttribute = true)
    private String certInfo;

    @JacksonXmlProperty(isAttribute = true)
    private String brandIconUrl;
    
    @JacksonXmlProperty(isAttribute = true)
    private String brandHomeUrl;
    
    @JacksonXmlProperty(isAttribute = true)
    private String brandSubscriptConfigUrl;

    @JacksonXmlProperty(isAttribute = true)
    private String brandFlags;

    @JacksonXmlProperty(isAttribute = true)
    private String regionCode;// 地区编码，如CN_Hubei_Wuhan
    
    @JacksonXmlProperty(localName = "antispamticket", isAttribute = true)
    private String antiSpamTicket;// 似乎只有个人名片有这个字段
}