package com.kuaike.skynet.logic.wechat.msg;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import lombok.Data;

/**
 * 微信定位
 * 
 * @Classname LocationMsg
 * @Description
 * @Date 2019/5/10 下午2:05
 * @Created by guokaijun
 */
@Data
@JacksonXmlRootElement(localName = "msg")
public class LocationMsg {

    private Location location;

    @Data
    public static class Location {
        private String x;

        private String y;

        private String scale;

        private String label;

        @JacksonXmlProperty(localName = "maptype")
        private String mapType;

        @JacksonXmlProperty(localName = "poiname")
        private String poiName;

        @JacksonXmlProperty(localName = "poiid")
        private String poiId;

        @JacksonXmlProperty(localName = "infourl")
        private String infoUrl;
    }

}