/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.wechat.utils;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.common.collect.Lists;
import com.kuaike.skynet.logic.wechat.dto.ReferMsgDto;
import com.kuaike.skynet.logic.wechat.dto.ReferMsgRespDto;
import com.kuaike.skynet.logic.wechat.enums.ReferMsgType;
import com.kuaike.skynet.logic.wechat.msg.LocationMsg;
import com.kuaike.skynet.logic.wechat.msg.QuoteMsg;
import java.util.LinkedList;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferMsgResolver {
    private static final Logger log = LoggerFactory.getLogger(ReferMsgResolver.class);
    private static final XmlMapper xmlMapper = new XmlMapper();

    public static ReferMsgRespDto parseReferMsg(String message) {
        ReferMsgRespDto dto = new ReferMsgRespDto();
        try {
            message = ReferMsgResolver.getInvalidMsg(message);
            QuoteMsg quoteMsg = (QuoteMsg)xmlMapper.readValue(message, QuoteMsg.class);
            QuoteMsg.QuoteAppMsg appmsg = quoteMsg.getAppmsg();
            dto.setContent(appmsg.getTitle());
            LinkedList referMsgDtoList = Lists.newLinkedList();
            ReferMsgResolver.collectReferMsg(message, referMsgDtoList);
            dto.setRefer(referMsgDtoList);
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u5f15\u7528\u6d88\u606f\u5931\u8d25:{}", (Object)message, (Object)e);
        }
        return dto;
    }

    private static ReferMsgRespDto parse(String title, QuoteMsg.ReferMsg referMsg) {
        String quote = "";
        StringBuilder builder = new StringBuilder();
        String displayName = referMsg.getDisplayName();
        builder.append(displayName).append(": ");
        String text = referMsg.getContent();
        log.info("\u89e3\u6790\u5f15\u7528\u6d88\u606f\uff1a{}", (Object)text);
        Integer type = referMsg.getType();
        ReferMsgType referMsgType = ReferMsgType.getByReferType(type);
        if (Objects.isNull((Object)referMsgType)) {
            return null;
        }
        switch (referMsgType) {
            case TEXT: {
                builder.append(text);
                break;
            }
            case IMAGE: 
            case VIDEO: 
            case GIF: {
                builder.append("[").append(referMsgType.getDesc()).append("]");
                break;
            }
            case LOCATION: {
                try {
                    text = ReferMsgResolver.getInvalidMsg(text);
                    LocationMsg locationMsg = (LocationMsg)xmlMapper.readValue(text, LocationMsg.class);
                    if (Objects.nonNull(locationMsg.getLocation()) && StringUtils.isNotBlank((CharSequence)locationMsg.getLocation().getPoiName())) {
                        quote = locationMsg.getLocation().getPoiName();
                    }
                }
                catch (Exception e) {
                    log.warn("\u5ffd\u7565\u5177\u4f53\u5f15\u7528\u5185\u5bb9:{}", (Object)text);
                }
                builder.append("[").append(referMsgType.getDesc()).append("]").append(quote);
                break;
            }
            case LINK: 
            case File: 
            case MINI_PROGRAM: 
            case REFER: {
                ReferMsgType msgType = null;
                try {
                    text = ReferMsgResolver.getInvalidMsg(text);
                    QuoteMsg appMsg = (QuoteMsg)xmlMapper.readValue(text, QuoteMsg.class);
                    QuoteMsg.QuoteAppMsg appmsg = appMsg.getAppmsg();
                    if (Objects.nonNull(appmsg) && Objects.nonNull(appmsg.getType()) && StringUtils.isNotBlank((CharSequence)appmsg.getTitle())) {
                        quote = appmsg.getTitle();
                        msgType = ReferMsgType.getByType(appmsg.getType());
                    }
                }
                catch (Exception e) {
                    log.warn("\u5ffd\u7565\u5177\u4f53\u5f15\u7528\u5185\u5bb9:{}", (Object)text);
                }
                if (Objects.isNull(msgType)) {
                    return null;
                }
                if (msgType == ReferMsgType.REFER) {
                    builder.append(quote);
                    break;
                }
                builder.append("[").append(msgType.getDesc()).append("]").append(quote);
                break;
            }
            default: {
                return null;
            }
        }
        ReferMsgRespDto dto = new ReferMsgRespDto();
        dto.setContent(title);
        return dto;
    }

    private static String getInvalidMsg(String msg) throws Exception {
        String start = "<msg";
        String end = "</msg>";
        int index = msg.indexOf(start);
        int endIndex = msg.indexOf(end);
        if (index == -1 || endIndex == -1) {
            throw new Exception("\u6d88\u606f\u5185\u5bb9\u683c\u5f0f\u9519\u8bef\uff0c\u65e0\u6cd5\u89e3\u6790");
        }
        msg = msg.substring(index, endIndex + end.length());
        return msg;
    }

    public static void collectReferMsg(String message, LinkedList<ReferMsgDto> referMsgSrvIdList) {
        try {
            QuoteMsg.ReferMsg referMsg;
            QuoteMsg.QuoteAppMsg appmsg;
            QuoteMsg quoteMsg = (QuoteMsg)xmlMapper.readValue(message, QuoteMsg.class);
            if (Objects.nonNull(quoteMsg) && Objects.nonNull(appmsg = quoteMsg.getAppmsg()) && Objects.nonNull(referMsg = appmsg.getReferMsg())) {
                String svrid = referMsg.getSvrid();
                String displayName = referMsg.getDisplayName();
                ReferMsgDto dto = new ReferMsgDto();
                dto.setNickname(displayName);
                dto.setMsgSrvId(svrid);
                dto.setType(referMsg.getType());
                if (referMsg.getType() == 1) {
                    dto.setContent(referMsg.getContent());
                }
                referMsgSrvIdList.addFirst(dto);
                ReferMsgResolver.collectReferMsg(referMsg.getContent(), referMsgSrvIdList);
            }
        }
        catch (Exception e) {
            log.debug("\u89e3\u6790\u5f15\u7528\u6d88\u606f\u5931\u8d25:{}", (Object)message, (Object)e);
        }
    }

    static {
        xmlMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }
}

