package com.kuaike.skynet.logic.wechat.msg;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 引用消息
 *
 */
@Data
@JacksonXmlRootElement(localName = "msg")
public class LinkCardMsg {

    private LinkAppMsg appmsg;

    @Data
    @EqualsAndHashCode(callSuper = false)
    public static class LinkAppMsg extends AppMsg {

        @JacksonXmlProperty(localName = "webviewshared")
        private WebViewShared webViewShared;

    }

    @Data
    public static class WebViewShared {

        private String shareUrlOriginal;

        private String shareUrlOpen;

        private String jsAppId;

        private String publisherId;

    }

}