package com.kuaike.skynet.logic.wechat.msg;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

import java.util.List;

import lombok.Data;

/**
 * Created by jiangtiteng on 2019-04-10
 */

@Data
@JacksonXmlRootElement(localName = "sysmsg")
public class JoinGroupMsg {

    @JacksonXmlProperty(isAttribute = true)
    private String type;

    @JacksonXmlProperty(localName = "sysmsgtemplate")
    private SysMsgTemplate sysMsgTemplate;

    @Data
    public static class SysMsgTemplate {

        @JacksonXmlProperty(localName = "content_template")
        private ContentTemplate contentTemplate;
    }

    @Data
    public static class ContentTemplate {

        @JacksonXmlProperty(isAttribute = true)
        private String type;

        private String plain;

        private String template;

        @JacksonXmlProperty(localName = "link_list")
        @JacksonXmlElementWrapper(useWrapping = true)
        private List<Link> linklist;

    }

    @Data
    public static class Link {
        @JacksonXmlProperty(isAttribute = true)
        private String name;

        @JacksonXmlProperty(isAttribute = true)
        private String type;
        
        @JacksonXmlProperty(isAttribute = true)
        private int hidden;

        private String separator;

        private String plain;
        
        private String title;

        // 扫码进群，会记录进群用户的wxid
        private String username;

        // 扫码进群，二维码
        private String qrcode;

        @JacksonXmlProperty(localName = "memberlist")
        @JacksonXmlElementWrapper(useWrapping = true)
        private List<Member> memberList;

        // name = revoke时，表示需要撤销邀请入群。此时usernameList中记录了成员的wxid。这些id跟memberList中的username是相同的。
        @JacksonXmlProperty(localName = "usernamelist")
        @JacksonXmlElementWrapper(useWrapping = true)
        private List<String> usernameList;
    }

    @Data
    public static class Member {

        private String username;

        private String nickname;
    }
}