/**
 * kuaike.com Inc. Copyright (c) 2014-2020 All Rights Reserved.
 */
package com.kuaike.skynet.logic.wechat.msg;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

import lombok.Data;

/**
 * @title GigMsg
 * @author yanmaoyuan
 * @date 2020年5月7日
 * @version 1.0
 */
@Data
@JacksonXmlRootElement(localName = "msg")
public class GigMsg {

    private Emoji emoji;

    @JacksonXmlProperty(localName = "gameext")
    private GameExt gameExt;

    @Data
    public static class Emoji {

        @JacksonXmlProperty(isAttribute = true, localName = "fromusername")
        private String fromUsername;

        @JacksonXmlProperty(isAttribute = true, localName = "tousername")
        private String toUsername;

        @JacksonXmlProperty(isAttribute = true)
        private int type;

        @JacksonXmlProperty(isAttribute = true, localName = "idbuffer")
        private String idBuffer;

        @JacksonXmlProperty(isAttribute = true, localName = "productid")
        private String productId;

        @JacksonXmlProperty(isAttribute = true)
        private String md5;

        @JacksonXmlProperty(isAttribute = true)
        private long len;

        @JacksonXmlProperty(isAttribute = true, localName = "androidmd5")
        private String androidMd5;

        @JacksonXmlProperty(isAttribute = true, localName = "androidlen")
        private long androidLen;

        @JacksonXmlProperty(isAttribute = true, localName = "s60v3md5")
        private String s60v3Md5;

        @JacksonXmlProperty(isAttribute = true, localName = "s60v3len")
        private long s60v3Len;

        @JacksonXmlProperty(isAttribute = true, localName = "s60v5md5")
        private String s60v5Md5;

        @JacksonXmlProperty(isAttribute = true, localName = "s60v5len")
        private long s60v5Len;

        @JacksonXmlProperty(isAttribute = true, localName = "cdnurl")
        private String cdnUrl;

        @JacksonXmlProperty(isAttribute = true, localName = "designerid")
        private String designerId;

        @JacksonXmlProperty(isAttribute = true, localName = "thumburl")
        private String thumbUrl;

        @JacksonXmlProperty(isAttribute = true, localName = "encrypturl")
        private String encryptUrl;

        @JacksonXmlProperty(isAttribute = true, localName = "aeskey")
        private String aesKey;

        @JacksonXmlProperty(isAttribute = true, localName = "externurl")
        private String externUrl;

        @JacksonXmlProperty(isAttribute = true, localName = "externmd5")
        private String externMd5;

        @JacksonXmlProperty(isAttribute = true)
        private int width;

        @JacksonXmlProperty(isAttribute = true)
        private int height;

        @JacksonXmlProperty(isAttribute = true, localName = "tpurl")
        private String tpUrl;

        @JacksonXmlProperty(isAttribute = true, localName = "tpauthkey")
        private String tpAuthKey;

        @JacksonXmlProperty(isAttribute = true, localName = "attachedtext")
        private String attachedText;

        @JacksonXmlProperty(isAttribute = true, localName = "attachedtextcolor")
        private String attachedTextColor;

        @JacksonXmlProperty(isAttribute = true, localName = "lensid")
        private String lensid;
    }

    @Data
    public static class GameExt {

        @JacksonXmlProperty(isAttribute = true)
        private int type;
        
        @JacksonXmlProperty(isAttribute = true)
        private String content;
    }

}