package com.kuaike.skynet.logic.wechat.msg;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import lombok.Data;

/**
 * 微信应用消息
 * 
 * @title AppMsg
 * @author yanmaoyuan
 * @date 2019年12月10日
 * @version 1.0
 */
@Data
public class AppMsg {

    @JacksonXmlProperty(isAttribute = true)
    private String appid;

    @JacksonXmlProperty(isAttribute = true)
    private String sdkver;

    private String title;

    private String des;

    private Integer type;

    private String url;

    @JacksonXmlProperty(localName = "thumburl")
    private String thumbUrl;

}