package com.kuaike.skynet.logic.wechat.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @description:
 * @author: liuguohong
 * @create: 2020/05/26 11:04
 */
//1-10: 邀请入群 , 11-20 :扫码入群, 21-30其他方式入群， 101 - 110 退群消息
public enum JoinGroupType {

    INVITE_1_SIMPLIFIED("\"$username$\"邀请你和\"$names$\"加入了群聊", 1),     //某人邀请了多个人入群
    INVITE_2_SIMPLIFIED("\"$username$\"邀请\"$names$\"加入了群聊", 2),
    INVITE_3_SIMPLIFIED("你邀请\"$names$\"加入了群聊  $revoke$", 3),  //拉好友入群
    INVITE_4_SIMPLIFIED("\"$username$\"邀请你加入了群聊，群聊参与人还有：$others$", 4), //群已发生过聊天，群主或群内好友拉机器人入群
    INVITE_5_SIMPLIFIED("\"$username$\"邀请你加入了群聊", 5), //群主创建群聊后，移除所有其他群成员，再邀请机器人入群，再群内发消息，机器人上显示

    SCAN_CODE_11_SIMPLIFIED("\"$adder$\"通过扫描你分享的二维码加入群聊  $revoke$", 11), //好友扫机器人的二维码入群
    SCAN_CODE_12_SIMPLIFIED("\" $adder$\"通过扫描\"$from$\"分享的二维码加入群聊",12), //群已创建，好友扫群内好友的二维码入群

    CREATE_21_SIMPLIFIED("\"$names$\"加入了群聊", 21), //机器人手机上面对面建群

    QUIT_GROUP_BY_KICK_SIMPLIFIED("你将\"$kickoutname$\"移出了群聊", 101),

    MOD_GROUP_NAME_SIMPLIFIED("\"$username$\"修改群名为“$remark$”", 201),

    OWNER_CHANGED_SIMPLIFIED("\"$ownername$\"已成为新群主", 301),
    /** -----------------------------   **/
    INVITE_1_TRADITIONAL("「$username$」邀請你和$names$加入了群組", 1),
    INVITE_2_TRADITIONAL("「$username$」邀請「$names$」加入了群組", 2),
    INVITE_3_TRADITIONAL("你邀請「$names$」加入了群組  $revoke$", 3),
    INVITE_4_TRADITIONAL("「$username$」邀請你加入了群組，成員還有：$others$", 4),
    INVITE_5_TRADITIONAL("「$username$」邀請你加入了群組", 5),

    SCAN_CODE_11_TRADITIONAL("「$adder$」透過掃描你分享的QR code加入群組  $revoke$",11),
    SCAN_CODE_12_TRADITIONAL("「$adder$」透過掃描「$from$」分享的QR Code加入群組。", 12),

    CREATE_21_TRADITIONAL("「$names$」加入了群組", 21),

    QUIT_GROUP_BY_KICK_TRADITIONAL("你將「$kickoutname$」移出了群組", 101),

    MOD_GROUP_NAME_TRADITIONAL("「$username$」修改群名為「$remark$」", 201),

    OWNER_CHANGED_TRADITIONAL("\"$ownername$\"已成為新群組建立者", 301),
    /** -----------------------------   **/

    INVITE_1_ENGLISH("invited you and $names$ to the group chat", 1),
    INVITE_2_ENGLISH("$username$ invited $names$ to the group chat", 2),
    INVITE_3_ENGLISH("You invited $names$ to the group chat.   $revoke$", 3),
    INVITE_4_ENGLISH("$username$ invited you to a group chat with $others$", 4),
    INVITE_5_ENGLISH("$username$ invited you to the group chat", 5),

    SCAN_CODE_11_ENGLISH("\"$adder$\" joined group chat via the QR code you shared.  $revoke$",11),
    SCAN_CODE_12_ENGLISH("\"$adder$\" joined the group chat via the QR Code shared by \"$from$\".", 12),

    CREATE_21_ENGLISH("\"$names$\" joined the group chat.", 21),

    QUIT_GROUP_BY_KICK_ENGLISH("You moved \"$kickoutname $\" out of group chat.", 101),

    MOD_GROUP_NAME_ENGLISH("\"$username$\" changed the group name to “$remark$”", 201),

    OWNER_CHANGED_ENGLISH("\"$ownername$\" changed the group owner", 301),

    ;

    private static final Map<String, JoinGroupType> MAP = new HashMap<>();

    public static final Map<Integer, String> JOIN_GROUP_TYPE_TO_DES_MAP =  new HashMap<>();

    private static final int INVITE = 1;   //邀请入群
    private static final int SCAN_CODE = 2; //扫码入群
    private static final int CREATE = 3;  //面对面建群

    static {
        for (JoinGroupType e : values()) {
            MAP.put(e.getTemplate(), e);
        }
        JOIN_GROUP_TYPE_TO_DES_MAP.put(INVITE, "邀请入群");
        JOIN_GROUP_TYPE_TO_DES_MAP.put(SCAN_CODE, "扫码入群");
        JOIN_GROUP_TYPE_TO_DES_MAP.put(CREATE, "面对面建群");
    }

    private final String template;// 消息模板

    private final int type;// 模版类型

    private JoinGroupType(String template, int type) {
        this.template = template;
        this.type = type;
    }

    public static String getJoinGroupTypeDesc(int type) {
        return JOIN_GROUP_TYPE_TO_DES_MAP.get(type);
    }

    /**
     * 入群的子类型，即type
     * @param template
     * @return
     */
    public static JoinGroupType getJoinGroupSubType(String template) {
        return MAP.get(template);
    }

    /**
     * 面向用户入群类型，按枚举定义，分为扫码、邀请、面对面建群
     * @param type
     * @return
     */
    public static Integer getJoinGroupType(int type) {
        if (type <= 10) {
            return INVITE;
        }
        if (type <= 20) {
            return SCAN_CODE;
        }
        return CREATE;
    }

    public String getTemplate() {
        return template;
    }

    public int getType() {
        return type;
    }

    public static boolean isJoinGroupType(JoinGroupType joinGroupType) {
        return joinGroupType.getType() < 100;
    }

    public static boolean isExitGroup(JoinGroupType joinGroupType) {
        return joinGroupType.getType() > 100 && joinGroupType.getType() < 200;
    }

    public static boolean isModGroupName(JoinGroupType joinGroupType) {
        return joinGroupType.getType() > 200 && joinGroupType.getType() < 300;
    }

    public static boolean isChangeGroupOwner(JoinGroupType joinGroupType) {
        return joinGroupType.getType() > 300 && joinGroupType.getType() < 400;
    }
}
