/**
 * Kuaikeguanjia.com Inc. Copyright (c) 2014-2020 All Rights Reserved.
 */
package com.kuaike.skynet.rc.service.riskControl.enums;

import com.google.common.collect.Maps;
import com.kuaike.common.enums.EnumService;

import java.util.Map;

/**
 * @title RcDealType
 * @author yanmaoyuan
 * @date 2020年4月21日
 * @version 1.0
 */
public enum RcDealType implements EnumService {

    NOTHING(0, "什么都不做"),
    KICK_ALL_NOTICE(1, "踢出所有群并发送踢人通告"), // 1：拉黑并踢出；
    KICK_ALL(2, "踢出所有群"), // 2：踢出所有群；
    WARN(3, "只发警告不踢人"),// 3：警告
    KICK(4, "踢出当前群"),// 4：踢出当前群

    ;

    private int value;

    private String desc;

    private final static Map<Integer, RcDealType> CACHE;

    static {
        CACHE = Maps.newHashMap();
        for (RcDealType e : values()) {
            CACHE.put(e.value, e);
        }
    }

    private RcDealType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    public static RcDealType getType(Integer dealType) {
        return CACHE.get(dealType);
    }
}