/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2020 All Rights Reserved.
 */
package com.kuaike.skynet.rc.service.riskControl.dto.resp;

import com.kuaike.skynet.rc.service.riskControl.dto.req.RcRuleAddRobotDto;
import com.kuaike.skynet.rc.service.riskControl.dto.req.RcRuleAntiJoinGroupDto;
import com.kuaike.skynet.rc.service.riskControl.dto.req.RcRuleListDto;
import com.kuaike.skynet.rc.service.riskControl.dto.req.RcRuleNicknameDto;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * @title RcDetailDto
 * @author yanmaoyuan
 * @date 2020年4月26日
 * @version 1.0
 */
@Data
public class RcDetailDto implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    /**
     * 风控方案编码
     */
    private String code;

    /**
     * 风控方案名称
     */
    private String name;

    /**
     * 是否激活,0:不生效;1:生效
     */
    private Boolean enabled;

    /**
     * 是否是系统方案
     * 
     * @see com.kuaike.skynet.rc.service.riskControl.enums.RcPlanLevel
     */
    private Integer level;

    /**
     * 绑定的微信群数量
     */
    private Integer chatroomCount;

    /**
     * 绑定的微信群列表
     */
    private List<String> chatroomIds;

    /**
     * 绑定的机器人微信号
     */
    private List<RcWechatDto> hosts;

    /**
     * 防广告
     */
    private RcRuleListDto message;
    
    /**
     * 昵称检测
     */
    private RcRuleNicknameDto nickname;

    /**
     * 防骚扰
     */
    private RcRuleListDto antiHarness;
    
    /**
     * 私加小号
     */
    private RcRuleAddRobotDto addRobot;

    /**
     * 防入群
     */
    private RcRuleAntiJoinGroupDto antiJoinGroup;

    /**
     * 踢人通告
     */
    private String kickNotice;

    /**
     * 警告通告
     */
    private String warnNotice;

}