/**
 * Kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2020 All Rights Reserved.
 */
package com.kuaike.skynet.rc.service.riskControl.dto.req;

import com.kuaike.skynet.rc.service.riskControl.enums.RcDealType;

import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 防加群
 * 
 * @title RcRuleAntiJoinGroupDto
 * @author yanmaoyuan
 * @date 2020年9月15日
 * @version 1.0
 */
@Data
@ToString(callSuper=true)
@EqualsAndHashCode(callSuper=true)
public class RcRuleAntiJoinGroupDto extends RcRuleDto {

    private static final long serialVersionUID = 1L;

    /**
     * 群成员触发风控敏感行为后的处理方式。
     * 
     * @see com.kuaike.skynet.rc.service.riskControl.enums.RcDealType
     */
    private Integer memberDealType = RcDealType.KICK.getValue();

    /**
     * 敏感行为检测列表
     */
    private List<RcRuleListItem> list;
}
