/**
 * Kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2020 All Rights Reserved.
 */
package com.kuaike.skynet.rc.service.riskControl.dto.req;

import com.kuaike.skynet.rc.service.common.dto.Operator;

import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 检测微信号是否已设置过风控方案。
 * 
 * @title RcPlanCheckReq
 * @author yanmaoyuan
 * @date 2020年4月26日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class RcPlanCheckReq extends Operator {

    private static final long serialVersionUID = 1L;

    /**
     * 方案ID
     */
    private Long id;

    /**
     * 微信号
     */
    private List<String> wechatIds;
}
