/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.reply.enums;

import com.google.common.collect.Maps;
import com.kuaike.skynet.logic.service.reply.enums.AutoReplyType;
import java.util.Map;

public enum FriendMsgReplyType {
    KEYWORD(1, AutoReplyType.KEY_WORD_REPLY, "keyword"),
    DEFAULT(2, AutoReplyType.DEFAULT_REPLY, "default"),
    IMAGE(3, AutoReplyType.DEFAULT_REPLY, "image"),
    VIDEO(4, AutoReplyType.DEFAULT_REPLY, "video"),
    VOICE(5, AutoReplyType.DEFAULT_REPLY, "voice"),
    FILE(6, AutoReplyType.DEFAULT_REPLY, "file"),
    MINI_PROGRAM(7, AutoReplyType.KEY_WORD_TAG_LABEL, "program"),
    LINK_CARD(8, AutoReplyType.KEY_WORD_TAG_LABEL, "link");

    static Map<Integer, FriendMsgReplyType> valueMap;
    static Map<String, FriendMsgReplyType> descMap;
    private int value;
    private AutoReplyType replyType;
    private String desc;

    private FriendMsgReplyType(int value, AutoReplyType replyType, String desc) {
        this.value = value;
        this.replyType = replyType;
        this.desc = desc;
    }

    public int getValue() {
        return this.value;
    }

    public AutoReplyType getReplyType() {
        return this.replyType;
    }

    public String getDesc() {
        return this.desc;
    }

    public static FriendMsgReplyType getType(Integer type) {
        return valueMap.get(type);
    }

    public static FriendMsgReplyType getType(String type) {
        return descMap.get(type);
    }

    static {
        valueMap = Maps.newHashMap();
        descMap = Maps.newHashMap();
        for (FriendMsgReplyType e : FriendMsgReplyType.values()) {
            valueMap.put(e.getValue(), e);
            descMap.put(e.getDesc(), e);
        }
    }
}

