/**
 * kuaike.com Inc. Copyright (c) 2014-2019 All Rights Reserved.
 */
package com.kuaike.skynet.logic.service.wechat.dto.resp;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * 添加好友自动备注的配置内容
 * 
 * @title AutoRemarkFriendDto
 * @author yanmaoyuan
 * @date 2019年12月13日
 * @version 1.0
 */
@Data
public class AutoRemarkFriendResp implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 该配置在数据库中的唯一ID
     */
    private Long id;

    /**
     * 适用的微信号
     */
    private String wechatId;

    /**
     * 开关，true 开启，false 禁用
     */
    private Boolean enabled;

    /**
     * 有效期开始时间
     */
    private Date startTime;

    /**
     * 有效期截止时间
     */
    private Date endTime;

    /**
     * 自动备注内容的格式，例如 <code>${content}-${nickname}-${date}</code>。<br/>
     * 
     * <code>${content}</code>表示验证信息<br/>
     * <code>${nickname}</code>表示昵称<br/>
     * <code>${date}</code>表示添加好友的日期，格式为yyyyMMdd<br/>
     */
    private String format;
}