/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package com.kuaike.skynet.logic.service.wechat.dto.resp;

import com.kuaike.skynet.logic.service.common.dto.resp.OperatorResp;
import com.kuaike.skynet.logic.service.common.dto.resp.WechatResp;

import java.io.Serializable;

import lombok.Data;

/**
 * 微信添加好后自动备注。
 * 
 * 查询列表时，列表中的item将按这个结构返回。
 * 
 * @title AutoRemarkFriendDetailRespDto
 * @author yanmaoyuan
 * @date 2019年12月13日
 * @version 1.0
 */
@Data
public class AutoRemarkFriendDetailRespDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 微信号的信息
     */
    private WechatResp wechat;

    /**
     * 配置内容，可能为null
     */
    private AutoRemarkFriendResp content;

    /**
     * 最后更新人的信息，可能为null
     */
    private OperatorResp updator;
}