package com.kuaike.skynet.logic.service.wechat.dto.req;

import com.google.common.base.Preconditions;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.List;

/**
 * @description: 被动添加好友配置List, 请求Dto
 * @author: liuguohong
 * @create: 2019/10/28 11:15
 */
@Data
public class PassiveAddFriendListReqDto implements Serializable {
    private static final long serialVersionUID = 8186847320816386691L;

    /** 微信昵称 */
    private String wechatId;

    private Integer timeSort; //0:正排，1：倒排

    private List<Long> userIds;

    private String query;

    /** 分页参数 */
    private PageDto pageDto;

    public void validate() {
        if (StringUtils.isBlank(wechatId)) {
            wechatId = null;
        }
        Preconditions.checkNotNull(pageDto, "分页参数不能为空");
        Preconditions.checkArgument(CollectionUtils.isNotEmpty(userIds), "userIds is not null");
    }
}
