/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package com.kuaike.skynet.logic.service.wechat.dto.req;

import com.kuaike.skynet.logic.service.common.dto.Operator;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 设置自动添加好友备注的开启状态
 * 
 * @title AutoRemarkFriendToggleReq
 * @author yanmaoyuan
 * @date 2019年12月13日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper=false)
@ToString(callSuper=true)
public class AutoRemarkFriendToggleReq extends Operator {

    private static final long serialVersionUID = 1L;

    /**
     * 微信ID
     */
    private String wechatId;

    /**
     * 开关状态 true 开启，false 关闭
     */
    private Boolean enabled;
}