/**
 * Kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2020 All Rights Reserved.
 */
package com.kuaike.skynet.logic.service.reply.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 私聊收到消息回复的类型
 * 
 * 
 * @title FriendMsgReplyType
 * @author yanmaoyuan
 * @date 2020年8月1日
 * @version 1.0
 */
public enum FriendMsgReplyType {

    KEYWORD(1, AutoReplyType.KEY_WORD_REPLY, "keyword"),

    DEFAULT(2, AutoReplyType.DEFAULT_REPLY, "default"),

    IMAGE(3, AutoReplyType.DEFAULT_REPLY, "image"),
    
    VIDEO(4, AutoReplyType.DEFAULT_REPLY, "video"),
    
    VOICE(5, AutoReplyType.DEFAULT_REPLY, "voice"),
    
    FILE(6, AutoReplyType.DEFAULT_REPLY, "file"),

    MINI_PROGRAM(7, AutoReplyType.KEY_WORD_TAG_LABEL,"program"),

    LINK_CARD(8, AutoReplyType.KEY_WORD_TAG_LABEL, "link"),
    
    ;

    static Map<Integer, FriendMsgReplyType> valueMap;

    static Map<String, FriendMsgReplyType> descMap;

    static {
        valueMap = Maps.newHashMap();
        descMap = Maps.newHashMap();
        for (FriendMsgReplyType e : values() ) {
            valueMap.put(e.getValue(), e);
            descMap.put(e.getDesc(), e);
        }
    }

    private int value;

    private AutoReplyType replyType;

    private String desc;

    private FriendMsgReplyType(int value, AutoReplyType replyType, String desc) {
        this.value = value;
        this.replyType = replyType;
        this.desc = desc;
    }

    /**
     * @return the value
     */
    public int getValue() {
        return value;
    }

    /**
     * @return the type
     */
    public AutoReplyType getReplyType() {
        return replyType;
    }

    /**
     * @return the desc
     */
    public String getDesc() {
        return desc;
    }

    /**
     * @param type
     */
    public static FriendMsgReplyType getType(Integer type) {
        return valueMap.get(type);
    }
    
    /**
     * @param type
     */
    public static FriendMsgReplyType getType(String type) {
        return descMap.get(type);
    }

}
