package com.kuaike.skynet.logic.service.reply.enums;

import com.google.common.collect.ImmutableMap;
import com.kuaike.common.enums.EnumService;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Classname AutoReplyType
 * @Description
 * @Date 2019/5/6 上午10:57
 * @Created by guokaijun
 */
public enum AutoReplyType implements EnumService {
    KEY_WORD_REPLY(1, "关键词匹配回复"),

    DEFAULT_REPLY(2, "收到消息自动回复"),

    JOIN_GROUP_REPLY(3, "入群回复"),

    SUBSCRIBED_REPLY(4, "被关注回复"),

    FISSION_RECEIVED_TASK_REPLY(5, "收到任务自动回复"),

    FISSION_REWARD_REPLY(6, "奖励自动回复"),

    ADD_FRIEND_REPLY(7, "添加好友回复"),

    KEY_WORD_TAG_LABEL(8, "关键词标签")

    ;

    private static final Map<Integer, AutoReplyType> MAP;

    static {
        MAP = ImmutableMap.copyOf(
                Arrays.stream(AutoReplyType.values()).collect(Collectors.toMap(AutoReplyType::getValue, Function.identity())));
    }

    private final int value;
    private final String desc;

    AutoReplyType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static AutoReplyType getType(int value) {
        return MAP.get(value);
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    public static Integer getValueByDesc(String desc){
        for (AutoReplyType type : MAP.values()){
            if (type.getDesc().equals(desc)){
                return type.getValue();
            }
        }
        return null;
    }

    public static String getDescByValue(Integer value){
        AutoReplyType type = getType(value);
        if (type != null){
            return type.getDesc();
        } else {
            return null;
        }
    }
}
