package com.kuaike.skynet.logic.service.reply.enums;

import com.google.common.collect.ImmutableMap;
import com.kuaike.common.enums.EnumService;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 自动回复关系类型
 * 
 * @Classname AutoReplyRelationType
 * @Description
 * @Date 2019/6/19 上午10:59
 * @Created by guokaijun
 */
public enum  AutoReplyRelationType implements EnumService {

    CHAT_ROOM(1, "微信群"),

    OFFICIAL_ACCOUNT(2, "公众号"),

    DRAINAGE_PLAN(3, "群引流"),

    FISSION_PLAN(4, "群裂变"),

    WECHAT(5, "微信号"),

    CHAT_ROOM_GROUP(6, "微信群组"),

    ;

    private static final Map<Integer, AutoReplyRelationType> MAP;

    static {
        MAP = ImmutableMap.copyOf(
                Arrays.stream(AutoReplyRelationType.values()).collect(Collectors.toMap(AutoReplyRelationType::getValue, Function.identity())));
    }

    private final int value;
    private final String desc;

    AutoReplyRelationType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static AutoReplyRelationType getType(int value) {
        return MAP.get(value);
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    public static Integer getValueByDesc(String desc) {
        for (AutoReplyRelationType type : MAP.values()) {
            if (type.getDesc().equals(desc)) {
                return type.getValue();
            }
        }
        return null;
    }

    public static String getDescByValue(Integer value) {
        AutoReplyRelationType type = getType(value);
        if (type != null) {
            return type.getDesc();
        } else {
            return null;
        }
    }
}
