package com.kuaike.skynet.logic.service.reply.enums;

import com.google.common.collect.ImmutableMap;
import com.kuaike.common.enums.EnumService;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Classname AutoReplyMessageType
 * @Description
 * @Date 2019/6/18 上午11:46
 * @Created by guokaijun
 */
public enum AutoReplyMessageType implements EnumService {
    MATERIAL(0, "素材"),

    TEXT(1, "文本"),

    IMAGE(2, "图片"),

    B_CARD(3, "名片"),

    FILE(9, "文件"),

    LINK(10, "链接"),
    
    VOICE(34, "语音"),

    VIDEO(43, "视频"),

    DRAINAGE(101, "群引流(流量漏斗)"),
    
    FISSION(102, "群裂变"),

    JOIN_GROUP_CARD(103, "加群卡片"),

    MINI_PROGRAM(104, "小程序"),

    OWNER_BCARD(105, "群主个人名片"),

    CONTACT_BCARD(106, "群主好友的个人名片"),

    OFFICIAL_NEWS(201, "公众号图文"),

    OFFICIAL_ACTI(202, "公众号裂变"),

    ;

    private static final Map<Integer, AutoReplyMessageType> MAP;

    static {
        MAP = ImmutableMap.copyOf(
                Arrays.stream(AutoReplyMessageType.values()).collect(Collectors.toMap(AutoReplyMessageType::getValue, Function.identity())));
    }

    private final int value;
    private final String desc;

    AutoReplyMessageType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static AutoReplyMessageType getType(Integer value) {
        return MAP.get(value);
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    public static Integer getValueByDesc(String desc){
        for (AutoReplyMessageType type : MAP.values()){
            if (type.getDesc().equals(desc)){
                return type.getValue();
            }
        }
        return null;
    }

    public static String getDescByValue(Integer value){
        AutoReplyMessageType type = getType(value);
        if (type != null){
            return type.getDesc();
        } else {
            return null;
        }
    }
}