package com.kuaike.skynet.logic.service.reply.dto.resp;

import com.kuaike.skynet.logic.service.reply.dto.AutoReplyMessageDto;
import com.kuaike.skynet.logic.service.reply.dto.AutoReplyWordDto;
import com.kuaike.skynet.logic.service.reply.dto.IdAndNameExtendDto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import lombok.Data;

/**
 * @Classname JoinGroupWelcomeListResp
 * @Description
 * @Date 2019/5/6 上午11:54
 * @Created by guokaijun
 */
@Data
public class ReplyListResp implements Serializable {
    private static final long serialVersionUID = 4250134862196630995L;
    /** ID */
    private Long id;
    /** 1-启用, 0-禁用 */
    private Integer enabled;
    /** 标题 */
    private String title;
    /** 关键词 */
    private AutoReplyWordDto keyWord;
    /** 关键词List */
    private List<AutoReplyWordDto> keyWordList;
    /** 问题 */
    private String request;
    /** 是否活动关键词 */
    private boolean isPlan;
    /** 回复内容 */
    private List<AutoReplyMessageDto> replyMessage;
    /** 适用范围 */
    private List<RoomToRobotDto> chatRooms;
    private List<String> wechatIds;
    /** 创建人ID */
    private Long createBy;
    /** 创建人 */
    private IdAndNameExtendDto creator;
    /** 创建时间 */
    private Date createTime;
    /** 更新人ID */
    private Long updateBy;
    /** 更新人 */
    private IdAndNameExtendDto updator;
    /** 更新时间 */
    private Date updateTime;
    /** 关系类型 */
    private Integer relationType;
    /** 回复类型 */
    private Integer replyType;
    /** 入群回复时间间隔 */
    private Integer timeIntervalMin;
    /** 入群回复时间间隔 */
    private Integer timeIntervalMax;
    /** 入群回复人数间隔 */
    private Integer memberInterval;
}