package com.kuaike.skynet.logic.service.reply.dto.req;

import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.skynet.logic.service.common.dto.Operator;
import com.kuaike.skynet.logic.service.reply.enums.AutoReplyRelationType;
import com.kuaike.skynet.logic.service.reply.enums.AutoReplyType;

import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @Classname JoinGroupWelcomeListReqDto
 * @Description
 * @Date 2019/4/30 下午4:22
 * @Created by guokaijun
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class ReplyListReqDto extends Operator {
    private static final long serialVersionUID = 2347574117984818756L;
    /** 自动回复关联类型 */
    private Integer relationType;
    /** 自动回复类型 */
    private Integer replyType;
    /** 群引流或群裂变id */
    private Long marketPlanId;
    /** 分页参数 */
    private PageDto pageDto;

    private List<Integer> relationTypeList;
    
    //private List<Integer> replyTypeList;
    
    // 商户id
    private Long merchantId;
    // 部门id
    private Long nodeId;
    private Long operatorId;

    private String keyword;

    private Integer timeSort; //0:正排，1：倒排

    private String title; //  标题
    
    public ReplyListReqDto (Integer relationType, Integer replyType) {
        this.relationType = relationType;
        this.replyType = replyType;
    }

    public ReplyListReqDto (AutoReplyRelationType relationTypeEnum, AutoReplyType replyTypeEnum) {
        this.relationType = relationTypeEnum.getValue();
        this.replyType = replyTypeEnum.getValue();
    }

    public ReplyListReqDto (){}
}
