package com.kuaike.skynet.logic.service.reply.dto.req;

import static com.kuaike.skynet.logic.service.reply.enums.AutoReplyRelationType.CHAT_ROOM;
import static com.kuaike.skynet.logic.service.reply.enums.AutoReplyType.JOIN_GROUP_REPLY;

import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @Classname JoinGroupReplyListReqDto
 * @Description
 * @Date 2019/6/18 下午3:55
 * @Created by guokaijun
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class JoinGroupReplyListReqDto extends ReplyListReqDto{
    private static final long serialVersionUID = -1998973968979039419L;
    /** 群分组id */
    private List<Long> groupIdList;
    /** 消息内容 */
    private String messageContent;
    private String chatRoomId;
    /** 群名称 */
    private String chatRoomName;

    public JoinGroupReplyListReqDto () {
        super(CHAT_ROOM, JOIN_GROUP_REPLY);
    }
}
