/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package com.kuaike.skynet.logic.service.reply.dto.req;

import com.kuaike.skynet.logic.service.reply.dto.AutoReplyWordDto;
import com.kuaike.skynet.logic.service.reply.dto.LogicReplyDto;
import com.kuaike.skynet.logic.service.reply.enums.AutoReplyRelationType;
import com.kuaike.skynet.logic.service.reply.enums.AutoReplyType;

import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 微信好友消息关键词回复
 * 
 * @title FriendKeywordReplyReqDto
 * @author yanmaoyuan
 * @date 2019年12月16日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper=false)
@ToString(callSuper=true)
public class FriendKeywordReplyReq extends LogicReplyDto {

    private static final long serialVersionUID = 1L;

    public FriendKeywordReplyReq() {
        super(AutoReplyRelationType.WECHAT, AutoReplyType.KEY_WORD_REPLY);
    }

    /**
     * 1-文本(关键词),2-默认回复,3-图片,4-视频,5-语音,6-文件
     * 
     * @see com.kuaike.skynet.logic.service.reply.enums.FriendMsgReplyType
     */
    private Integer rtype;

    /**
     * 微信号
     */
    private List<String> wechatIds;

    /**
     * 关键词
     */
    private AutoReplyWordDto keyWord;
}