/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package com.kuaike.skynet.logic.service.reply.dto.req;

import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.skynet.logic.service.common.dto.Operator;

import java.util.Date;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 查询微信好友关键词回复的参数
 * 
 * @title FriendKeywordReplyListReqDto
 * @author yanmaoyuan
 * @date 2019年12月16日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper=false)
@ToString(callSuper=true)
public class FriendKeywordReplyListReq extends Operator {

    private static final long serialVersionUID = 1L;

    // 关键词筛选条件 (可不传)
    /**
     * 关键词
     */
    private String keywordQuery;

    // 微信筛选条件 (可不传)
    /**
     * 微信号
     */
    private String wechatId;

    // 更新人筛选条件 (可不传)
    /**
     * 更新人
     */
    private Long userId;

    /**
     * 消息类型 (可不传)
     * 1-文本(关键词),2-默认回复,3-图片,4-视频,5-语音,6-文件
     * 
     * @see com.kuaike.skynet.logic.service.reply.enums.FriendMsgReplyType
     */
    private Integer rtype;

    // 更新时间筛选条件 (可不传)
    
    /**
     * 更新开始时间
     */
    private Date updateStartTime;

    /**
     * 更新截止时间
     */
    private Date updateEndTime;

    /**
     * 按更新时间排序，0-升序，1-降序
     */
    private Integer timeSort = 1;

    /**
     * 分页查询参数 (可不传)
     */
    private PageDto pageDto;
}