/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package com.kuaike.skynet.logic.service.reply.dto.req;

import com.kuaike.skynet.logic.service.common.dto.Operator;

import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 微信好友私聊关键词检测
 * 
 * @title FriendKeywordReplyCheckReq
 * @author yanmaoyuan
 * @date 2019年12月16日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ToString(callSuper=true)
public class FriendKeywordReplyCheckReq extends Operator {

    private static final long serialVersionUID = 1L;

    // 自动回复ID
    private Long id;

    /**
     * 1-文本(关键词),2-默认回复,3-图片,4-视频,5-语音,6-文件
     * 
     * @see com.kuaike.skynet.logic.service.reply.enums.FriendMsgReplyType
     */
    private Integer rtype;

    // 匹配类型 1-精确匹配 2-模糊匹配
    private Integer type;

    private String keyword;
    
    private List<String> wechatIds;
}
