package com.kuaike.skynet.logic.service.reply.dto.req;

import static com.kuaike.skynet.logic.service.reply.enums.AutoReplyRelationType.CHAT_ROOM;
import static com.kuaike.skynet.logic.service.reply.enums.AutoReplyType.KEY_WORD_REPLY;

import com.kuaike.skynet.logic.service.reply.dto.AutoReplyWordDto;
import com.kuaike.skynet.logic.service.reply.dto.LogicReplyDto;
import com.kuaike.skynet.logic.service.reply.dto.RobotToRoomDto;

import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode(callSuper = true)
@Data
public class AutoReplyReqDto extends LogicReplyDto {
	
	public AutoReplyReqDto () {
		super(CHAT_ROOM, KEY_WORD_REPLY);
    }
	
	private static final long serialVersionUID = -4437175837660776620L;

    /**
     * 微信群列表
     */
    private List<RobotToRoomDto> chatRooms;
    
    /**
     * 关键词
     */
    private AutoReplyWordDto keyWord;
    
    private List<AutoReplyWordDto> keyWordList;

}
