package com.kuaike.skynet.logic.service.reply.dto.req;

import static com.kuaike.skynet.logic.service.reply.enums.AutoReplyRelationType.WECHAT;
import static com.kuaike.skynet.logic.service.reply.enums.AutoReplyType.ADD_FRIEND_REPLY;

import com.kuaike.skynet.logic.service.reply.dto.LogicReplyDto;

import java.util.Collection;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @description: 添加好友回复设置新增修改
 * @author: liuguohong
 * @create: 2019/10/25 13:56
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ToString(callSuper=true)
public class AddFriendReplyReqDto extends LogicReplyDto {
    private static final long serialVersionUID = -45852820378478579L;

    private Collection<String> wechatIds;

    public AddFriendReplyReqDto () {
        super(WECHAT, ADD_FRIEND_REPLY);
    }

}