package com.kuaike.skynet.logic.service.reply.dto.req;

import lombok.Data;
import lombok.EqualsAndHashCode;


import static com.kuaike.skynet.logic.service.reply.enums.AutoReplyRelationType.WECHAT;
import static com.kuaike.skynet.logic.service.reply.enums.AutoReplyType.ADD_FRIEND_REPLY;

/**
 * @description: 添加好友回复配置Dto
 * @author: liuguohong
 * @create: 2019/10/25 10:59
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class AddFriendReplyListReqDto extends ReplyListReqDto {
    private static final long serialVersionUID = -7936269759452768599L;

    /** 微信昵称 */
    private String wechatId;
    //更新人昵称
    private String userName;

    public AddFriendReplyListReqDto () {
        super(WECHAT, ADD_FRIEND_REPLY);
    }
}
