/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package com.kuaike.skynet.logic.service.reply.dto.label;

import com.kuaike.skynet.logic.service.common.dto.resp.OperatorResp;
import com.kuaike.skynet.logic.service.common.dto.resp.WechatResp;
import com.kuaike.skynet.logic.service.reply.dto.AutoReplyMessageDto;
import com.kuaike.skynet.logic.service.reply.dto.AutoReplyWordDto;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 查询微信好友私聊关键词回复详情
 * 
 * @title FriendKeywordReplyDetailResp
 * @author yanmaoyuan
 * @date 2019年12月16日
 * @version 1.0
 */
@Data
public class FriendKeywordLabelDetailResp implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 唯一ID
     */
    private Long id;

    private List<Integer> rtypes;


    /**
     * 模糊匹配关键词，多个关键词使用","分割
     */
    private String fuzzyKeyword;

    /**
     * 精确匹配关键词，多个关键词使用","分割
     */
    private String accurateKeyword;

    /**
     * 标签详情
     */
    private List<LabelItemDto> labelItemDtoList;

    private WechatResp wechatDetail;

    /**
     * 最后更新人的信息，可能为null
     */
    private OperatorResp updator;
}
