package com.kuaike.skynet.logic.service.reply.dto;

import lombok.Data;
import lombok.EqualsAndHashCode;

import static com.kuaike.skynet.logic.service.reply.enums.AutoReplyRelationType.FISSION_PLAN;
import static com.kuaike.skynet.logic.service.reply.enums.AutoReplyType.FISSION_RECEIVED_TASK_REPLY;

/**
 * @Classname TaskConfigManipulateReqDto
 * @Description
 * @Date 2019/6/17 下午4:31
 * @Created by guokaijun
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class TaskConfigManipulateReqDto extends LogicReplyDto {
    private static final long serialVersionUID = -8369740903865397800L;
    /** 发图人数间隔 */
    private Integer peopleInterval;

    /** 发消息时间间隔 */
    private Integer intervalTime;

    /** 审核间隔 */
    private Integer auditTime;

    /** 是否开启自动回复 */
    private Boolean isAutoReply;

    /** 裂变方案Id */
    private Long  fissionPlanId;

    public TaskConfigManipulateReqDto() {
        super(FISSION_PLAN, FISSION_RECEIVED_TASK_REPLY);
    }
}
